<?php
defined('_JEXEC') or die;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'templates/puebla/html/mod_menu/css/style.css');


$id = '';
if ($tagId = $params->get('tag_id', '')) {
    $id = ' id="' . htmlspecialchars($tagId, ENT_QUOTES, 'UTF-8') . '"';
}
?>
<div class="uk-position-fixed uk-position-bottom-left uk-margin-small-left uk-margin-small-bottom" style="z-index: 1050;">
    <div class="uk-navbar-left">
        <button class="uk-icon-button uk-margin-small-top button_informa" type="button">
            <span uk-icon="icon: more-vertical; ratio: 1.5"></span>
        </button>
        <div class="uk-navbar-dropdown dropdown-float uk-margin-remove" uk-drop="pos: top-left; delay-hide:300; animation: uk-animation-slide-bottom-small">
            <ul class="uk-nav uk-navbar-dropdown-nav <?php echo htmlspecialchars($class_sfx, ENT_QUOTES, 'UTF-8'); ?>"<?php echo $id; ?>>
                <?php foreach ($list as $i => &$item) :
                    $class = 'item-' . $item->id;
                    if ($item->id == $default_id) $class .= ' default';
                    if ($item->id == $active_id || ($item->type === 'alias' && $item->params->get('aliasoptions') == $active_id)) $class .= ' current';
                    if (in_array($item->id, $path)) $class .= ' active';
                    elseif ($item->type === 'alias') {
                        $aliasToId = $item->params->get('aliasoptions');
                        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) $class .= ' active';
                        elseif (in_array($aliasToId, $path)) $class .= ' alias-parent-active';
                    }
                    if ($item->type === 'separator') $class .= ' divider';
                    if ($item->deeper) $class .= ' deeper';
                    if ($item->parent) $class .= ' uk-parent';
                    echo '<li class="' . $class . ' item_float uk-margin-small-top">';
                    switch ($item->type) :
                        case 'separator':
                        case 'component':
                        case 'heading':
                        case 'url':
                            require ModuleHelper::getLayoutPath('mod_menu', 'dst-float_' . $item->type);
                            break;
                        default:
                            require ModuleHelper::getLayoutPath('mod_menu', 'dst-float_url');
                            break;
                    endswitch;
                    if ($item->deeper) echo '<ul class="nav-child unstyled small uk-nav-sub">';
                    elseif ($item->shallower) {
                        echo '</li>';
                        echo str_repeat('</ul></li>', $item->level_diff);
                    } else echo '</li>';
                endforeach; ?>
            </ul>
        </div>
    </div>
</div>