<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\RouteHelper;

/** @var \Joomla\Component\Content\Site\View\Article\HtmlView $this */
// Create shortcuts to some parameters.
$params  = $this->item->params;
$canEdit = $params->get('access-edit');
$user    = $this->getCurrentUser();
$info    = $params->get('info_block_position', 0);
$htag    = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// Check if associations are implemented. If they are, define the parameter.
$assocParam        = (Associations::isEnabled() && $params->get('show_associations'));
$currentDate       = Factory::getDate()->format('Y-m-d H:i:s');
$isNotPublishedYet = $this->item->publish_up > $currentDate;
$isExpired         = !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;

$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName('params'))
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('id') . ' = ' . (int) $this->item->catid);
$db->setQuery($query);
$paramsJson = $db->loadResult();

if ($paramsJson) {
    $paramsI = json_decode($paramsJson);
    $catImage = $paramsI->image ?? '';
}

/*** ATENCIÓN */
/** Slider es ID 18, Plan de estudios es 11 y  */

/*COlores*/
$grade = '';
$colors = []; // Aquí guardaremos los 4 colores

switch ($this->item->category_title) {
    case "Bachillerato":
        $grade  = "Bachillerato";
        $colors = ["#c8d4ff", "#e4eaff", "#c3cdf0", "#dbe1f8"];
        break;

    case "Licenciatura":
        $grade  = "Licenciatura";
        $colors = ["#fff9ef", "#fef2dd", "#f9f1e4", "#fff7eb"];
        break;

    case "Maestrías":
        $grade  = "Maestrías";
        $colors = ["#e6eeec", "#e0f7f1", "#d7e3e0", "#d5eee7"];
        break;

    case "Doctorado":
        $grade  = "Doctorado";
        $colors = ["#eedfca", "#f5e4c5", "#e7d6b8", "#eedcbd"];
        break;

    case "Especializaciones":
        $grade  = "Especializaciones";
        $colors = ["#c9cbda", "#daddf3", "#babdcc", "#d0d6f0"];
        break;

    default:
        $grade  = "Sin categoría";
        $colors = ["#e1dbcd", "#f4ebda", "#dfd4c2", "#f2e3cc"]; // colores por defecto
        break;
}

?>





<div class="uk-margin-large-bottom">
    <div class="uk-height-medium uk-flex uk-flex-center uk-flex-middle uk-background-cover uk-light uk-position-relative br" 
         data-src="<?= "/ucips/" . $catImage ?>" uk-img>
        <h1 class="uk-text-bold uk-position-center-left uk-padding-small"><?= $this->item->category_title ?></h1>
        <img src="images/ucips_logo_banner_interno_flotado.png" alt="Bienvenidos UCIPS" class="uk-position-center-right uk-padding-small" style="max-height:80%;">
    </div>

    <div class="uk-flex-middle uk-margin-large-top" uk-grid>
        <div class="uk-width-2-3@m">
            <h4><?= $this->item->title ?></h4>
            <p><?= $this->item->introtext ?></p>
        </div>
        <div class="uk-width-1-3@m">
            <div class="custom-slideshow">
                <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="ratio: 9:9; animation: push">

                    <div class="uk-slideshow-items br">
                        <?php 
                            $fieldId = 18; // ID del subform
                            if (!empty($this->item->jcfields[$fieldId]->rawvalue)) {
                                $galleryData = json_decode($this->item->jcfields[$fieldId]->rawvalue, true);
                            
                                if (!empty($galleryData)) {
                                    foreach ($galleryData as $rowKey => $row) {
                                        foreach ($row as $fieldKey => $field) {
                                            if (!empty($field['imagefile'])) {
                                                $image = explode('#', $field['imagefile'])[0]; // limpia #joomlaImage
                                                echo "<div>";
                                                    echo '<img class="br" src="' . htmlspecialchars($image, ENT_QUOTES) . '" alt="' . htmlspecialchars($field['alt_text'] ?? '', ENT_QUOTES) . '" uk-cover>';
                                                echo "</div>";
                                            }
                                        }
                                    }
                                }
                            }
                        ?>
                    </div>

                    <!-- Navegación anterior/siguiente -->
                    <a class="uk-position-center-left uk-position-small uk-hidden-hover" href uk-slidenav-previous uk-slideshow-item="previous"></a>
                    <a class="uk-position-center-right uk-position-small uk-hidden-hover" href uk-slidenav-next uk-slideshow-item="next"></a>

                    <!-- Dot navigation -->
                    <ul class="uk-slideshow-nav uk-dotnav uk-flex-center uk-margin"></ul>

                </div>
            </div>
        </div>
    </div>

    <div class="uk-margin-large-top">
        <h4> Plan de estudios </h4>
        <?php 
            $fieldPlan = 11; //El id del plan de estudios 
            echo $this->item->jcfields[$fieldPlan]->rawvalue;
        ?>
        
    </div>
    
    <ul uk-accordion>
        <?php $fieldSen = 12; // ID del campo semestre ?>
        <?php if (!empty($this->item->jcfields[$fieldSen]->rawvalue)): ?>
            <?php $data = json_decode($this->item->jcfields[$fieldSen]->rawvalue, true); ?>
            <?php foreach ($data as $semestre): ?>
                <?php $nombreSemestre = $semestre['field13']; ?>
                <li class="" style="box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 12px;">
                    <a class="uk-accordion-title pad20" href="#"> <strong><?= htmlspecialchars($nombreSemestre) ?></strong> </a>
                    <div class="uk-accordion-content">
                        <table class="uk-table uk-table-divider">
                            <tbody>
                                <?php foreach ($semestre['field17'] as $materia): ?>
                                    <?php 
                                        $numeroMateria = $materia['field14'];
                                        $nombreMateria = $materia['field15'];
                                        $descripcion   = $materia['field16'];
                                    ?>
                                    <tr>
                                        <td class="uk-text-center uk-text-middle wi15" style="width="><?= htmlspecialchars($numeroMateria) ?></td>
                                        <td class="uk-text-justify">
                                            <strong><?= htmlspecialchars($nombreMateria) ?></strong> 
                                            <?= htmlspecialchars($descripcion) ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </li>
            <?php endforeach; ?>
        <?php endif; ?>
    </ul>


    <!--<div class="uk-margin-large-top">
        <div class="uk-overflow-auto">
            <table class="uk-table uk-table-middle uk-table-divider">
                <?php $fieldSen = 12; //El id del semestre  ?>

                <?php if (!empty($this->item->jcfields[$fieldSen]->rawvalue)): ?>
                    <?php $data = json_decode($this->item->jcfields[$fieldSen]->rawvalue, true); ?>
                        <?php foreach ($data as $semestre): ?>
                            <?php $nombreSemestre = $semestre['field13']; ?>
                            <thead>
                                <tr>
                                    <th class="uk-width-small"> <strong><?= $nombreSemestre ?></strong> </th>                
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($semestre['field17'] as $materia): ?>
                                <?php 
                                    $numeroMateria = $materia['field14'];
                                    $nombreMateria = $materia['field15'];
                                    $descripcion   = $materia['field16'];            
                                ?>
                                
                                <tr>
                                    <td><?= $numeroMateria ?></td>
                                    <td class="uk-text-justify"><strong><?= $nombreMateria ?></strong> <?= $descripcion ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        <?php endforeach; ?>
                <?php endif; ?>
            </table>
        </div>
    </div>-->
</div>


<p class="m15 uk-margin-remove-bottom" style="background: #ee9e45; color:white; font-weight:bold; padding:15px;">Admisiones</p>

<?php 
$fieldAdm = 23; //El id de Admisiones
$imgAdm = json_decode($this->item->jcfields[$fieldAdm]->rawvalue); 
$imgAdm2 = explode('#', $imgAdm->row0->field22->imagefile)[0];

echo '<img class="m15" src="' . htmlspecialchars($imgAdm2, ENT_QUOTES) . '" alt="' . htmlspecialchars($field['alt_text'] ?? '', ENT_QUOTES) . '">';

$fieldReq = 26; //El id de Los requisitos de las admisiones

$dataReq = json_decode($this->item->jcfields[$fieldReq]->rawvalue);

// Verificar que la estructura existe
echo "<div class='uk-padding' style='color: #b3b3b3'>";
    echo "<h3 style='color: #666'>Requisitos:</h3>";
    if (isset($dataReq->row0->field27) && isset($dataReq->row0->field24)) {
        echo "<div class='uk-column-1-1@xs uk-column-1-1@s uk-column-1-2@m uk-column-1-2@l uk-text-justify'> ";
            echo "<p>" . $dataReq->row0->field24 . "</p>";
            echo "<ul class='lista-sin-puntos'>";
                $i=97;
                foreach ($dataReq->row0->field27 as $key => $document) {
                    if (isset($document->field25)) {
                        echo "<li>" . "<strong>" . chr($i) . ")" . "</strong>" ."   " . $document->field25 . "</li>" ;
                        echo "</br>";
                    }
                    $i++;
                }
            echo "<ul>";
        echo "</div>";
    }
echo "</div>";
$fieldHora = 31; //El id de extrai que son los horarios
$dataHora = json_decode($this->item->jcfields[$fieldHora]->rawvalue);

$fieldCuota = 32; //El id de extraii que son los de cuota de recuperación
$dataCuota = json_decode($this->item->jcfields[$fieldCuota]->rawvalue);

?>

<div class="uk-child-width-expand@s m15" uk-grid>
    <div class="uk-grid-item-match bgc-f0f0f0 padbox">
        <div class="">
            <h4 class="c-666">Horarios</h4>
            <?php 
            if (isset($dataHora) && !empty($dataHora)) {
                echo "<ul class='uk-list  '>";
                foreach ($dataHora as $row) {
                    if (isset($row->field28)) {
                        echo "<li>" .  "<strong>" . htmlspecialchars($row->field28) . "</strong>" . "</li>";
                    }
                }
                echo "</ul>";
            } else {
                echo '<p class="uk-text-muted">Horario no disponible</p>';
            }
            ?>
        </div>
    </div>
    <div class="bgc-f9f9f9 padbox">
        <div >
            <h4 class="c-666" >CUOTA DE <strong>RECUPERACIÓN</strong></h4>
            <?php 
            if (isset($dataCuota) && !empty($dataCuota)) {
                echo "<ul style='padding-right: 10rem;' class='uk-list c-666'>";
                foreach ($dataCuota as $row) {
                    if (isset($row->field29)) {
                        $parts = explode('$', $row->field29);
                        $concepto = trim($parts[0]);
                        $monto = isset($parts[1]) ? '$' . trim($parts[1]) : '';
                        
                        echo "<li class='uk-flex uk-flex-between uk-flex-middle'>";
                        echo "<span class='uk-text-bold'>" . htmlspecialchars($concepto) . "</span>";
                        echo "<span class='uk-text-bold'>" . htmlspecialchars($monto) . "</span>";
                        echo "</li>";
                    }
                }
                echo "</ul>";
            } else {
                echo '<p class="uk-text-muted">Información de cuota no disponible</p>';
            }
            ?>
        </div>
    </div>
</div>

<?php
$fieldImgText = 33; //El id del texto de La imagen
$fieldImg = 34;

$datafieldImg=json_decode($this->item->jcfields[$fieldImg]->rawvalue);
$datafieldImg2 = explode('#', $datafieldImg->imagefile);


$fieldcolor1 = 35;
$fieldcolor1=$this->item->jcfields[$fieldImg]->rawvalue;
$fieldDir = 36;
$fieldColor2 = 37;
?>

<section class="admisiones uk-section uk-padding-remove-top uk-padding-remove-bottom m15">
  <div class="uk-container uk-flex uk-flex-middle uk-flex-between uk-flex-wrap h325">

    <!-- Texto -->
    <div class="texto uk-width-1-2@l uk-width-1-1@s uk-padding-small">
      
      <p>
        <?= $this->item->jcfields[$fieldImgText]->rawvalue ?>
      </p>
      
    </div>

    <!-- Imagen del teléfono -->
    <div class="imagen uk-width-1-2@l uk-width-1-1@s uk-text-center uk-padding-small">
      <?php  echo '<img class="telefono-img" src="' . htmlspecialchars($datafieldImg2[0], ENT_QUOTES) . '" alt="' . htmlspecialchars($field['alt_text'] ?? '', ENT_QUOTES) . '">'; ?>
    </div>

  </div>
</section>
<section class="dir-info m15">
  <p>Km 6.5 Camino Vecinal a San Salvador Chachapa,<br>
  C.P. 72700, Santa Cruz Alpyueca, Puebla<br>
  <strong>programas_educacionsuperior@aiz.cesppuebla.gob.mx</strong><br>
  Teléfono 2221441000 ext 32134</p>
</section>

<style>

.lista-sin-puntos {
    list-style-type: none;
    padding-left: 0; /* Opcional: ajusta el padding si es necesario */
}


/* Filas impares (1, 3, 5...) */
tbody tr:nth-child(odd) td:first-child {
    background-color: <?= $colors[0] ?>;
}
tbody tr:nth-child(odd) td:nth-child(2) {
    background-color: <?= $colors[1] ?>;
}

/* Filas pares (2, 4, 6...) */
tbody tr:nth-child(even) td:first-child {
    background-color: <?= $colors[2] ?>;
}
tbody tr:nth-child(even) td:nth-child(2) {
    background-color: <?= $colors[3] ?>;
}

 /* Solo dots del slideshow con clase custom-slideshow */
.custom-slideshow .uk-dotnav li a {
    background-color: #a77f8a;
}

.custom-slideshow .uk-dotnav li.uk-active a {
    background-color: #4f0016;
}

.m15{
    margin: 0 -15px;
}

.padbox{
    padding: 40px 40px 250px 55px;
}

.br{
    border-radius: 50px;
    /*box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;*/
}

.pad20{
    padding: 20px;
}

.wi15{
    width: 15%;
}

.bgc-f0f0f0{
    background-color: #f0f0f0;
}

.bgc-f9f9f9{
    background-color: #f9f9f9;
}

.c-666{
    color: #666;
}


/*Admisones*/

.h325{
    height: 325px;
}

.admisiones {
  position: relative;
  background: linear-gradient(90deg, #ffffff 35%, <?= $colors[0] ?> 100%);
  /*border-radius: 20px;*/
  overflow: visible; /* permite que la imagen sobresalga */
  /*margin: 80px auto;  deja espacio visual arriba */
  padding-bottom: 0; /* la imagen estará pegada al fondo */
  box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}

.admisiones .titulo {
  font-weight: 300;
  font-size: 1.6rem;
  color: #444;
  margin-bottom: 15px;
}

.admisiones .titulo strong {
  color: #555;
}

.admisiones p {
  color: #555;
  line-height: 1.6;
  font-size: 1rem;
  margin-bottom: 10px;
}

/* Contenedor de la imagen */
.imagen {
  position: relative;
}

/* Imagen sobresaliendo por arriba y pegada abajo */
.telefono-img {
  position: absolute;
  /*bottom: 0;            pegada al fondo de su sección */
  bottom: -283px;
  right: 20px;         /* separada un poco del borde */
  transform: translateY(-35%); /* sobresale hacia arriba */
  /*width: 320px;*/
  max-width: 90%;
  height: auto;
  filter: drop-shadow(8px 10px 15px rgba(0,0,0,0.25));
}

/* Versión móvil */
@media (max-width: 780px) {
  .admisiones {
    text-align: center;
    background: linear-gradient(180deg, #ffffff 0%, #e4eaff 100%);
    margin: 40px 10px;
  }

  .uk-container {
    flex-direction: column;
  }

  .imagen {
    position: relative;
    width: 100%;
  }

  .telefono-img {
    position: static;
    transform: none;
    width: 70%;
    margin-top: 20px;
  }
}

.dir-info {
  background-color: #ec9a44; /* tono naranja similar */
  color: white;
  text-align: center;
  font-family: 'Inter', 'Helvetica Neue', Arial, sans-serif;
  padding: 30px 10px;
  line-height: 1.6;
  font-size: 15px;
}

.dir-info strong {
  font-weight: 700;
}


</style>