<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\RouteHelper;

// Create shortcuts to some parameters.
$params  = $this->item->params;
$canEdit = $params->get('access-edit');
$user    = $this->getCurrentUser();
$info    = $params->get('info_block_position', 0);
$htag    = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// Check if associations are implemented. If they are, define the parameter.
$assocParam        = (Associations::isEnabled() && $params->get('show_associations'));
$currentDate       = Factory::getDate()->format('Y-m-d H:i:s');
$isNotPublishedYet = $this->item->publish_up > $currentDate;
$isExpired         = !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;

?>

<!--<div class="flags uk-container uk-flex uk-flex-right uk-flex-middle uk-margin-large-top uk-margin-large-bottom">-->
<div class="marg uk-child-width-1-2@s uk-child-width-1-2@m uk-grid" uk-grid>
    <div class="left-side item-title-img uk-width-2-5@l uk-width-2-5@m uk-width-1-1@s">
        <div class="img-container uk-width-1@m">
            <?php echo LayoutHelper::render('joomla.content.full_image', $this->item); ?>
        </div>
        <div class="separator-with-border"></div>
        
        <?php
        $band = false;
        
        foreach ($this->item->jcfields as $field)
        {
            
            if ($field->type == 'subform' && $field->name == 'galeria')
            {
            
                if (!empty($field->rawvalue) && !empty($field->subform_rows))
                {
                    $band = true;
                    break; 
                }
            }
        }
        ?>
        
        <?php if ($band): ?>
            <h5>Ver Galería</h5>
        <?php endif; ?>
        
        <div class="uk-child-width-1-4@xl uk-child-width-1-4@l uk-child-width-1-2@m uk-child-width-1-3@s uk-child-width-1-2@xs" uk-grid uk-lightbox="animation: fade">
            <?php $archivos = [];  ?>
            <?php foreach ($this->item->jcfields as $field): ?>
                <?php if ($field->type == 'media' && !empty($field->rawvalue)): ?>
                    <?php $fr = json_decode($field->rawvalue); ?>
                    <?php ?>
                    
                    <?php if (!empty($fr->imagefile)): ?>
                        <div>
                            <a class="uk-inline" href="<?php echo htmlspecialchars($fr->imagefile); ?>" data-caption="Imagen">
                                <img src="<?php echo htmlspecialchars($fr->imagefile); ?>" alt="<?php echo htmlspecialchars($fr->alt_text); ?>">
                            </a>
                        </div>
                    <?php endif; ?>
                <?php elseif ($field->type == 'subform' && $field->name == 'galeria' && !empty($field->subform_rows)): ?>
                    <?php foreach ($field->subform_rows as $row): ?>
                        
                        <?php
                            $nombreArchivo = '';
                            $rutaArchivo = '';
                        ?>
                    
                        <?php foreach ($row as $subfield): ?>
                            <?php if ($subfield->type == 'media' && !empty($subfield->rawvalue)): ?>
                            
                                
                                <?php 
                                // Para subform, rawvalue ya es un array, no necesita json_decode
                                $imagefile = is_array($subfield->rawvalue) ? $subfield->rawvalue['imagefile'] : '';
                                $alt_text = is_array($subfield->rawvalue) ? $subfield->rawvalue['alt_text'] : '';
                                ?>
                                <?php if (!empty($imagefile)): ?>
                                
                                    <div>
                                        <a class="uk-inline" href="<?php echo htmlspecialchars($imagefile); ?>" data-caption="Imagen">
                                            <img src="<?php echo htmlspecialchars($imagefile); ?>" alt="<?php echo htmlspecialchars($alt_text); ?>">
                                        </a>
                                    </div>
                                <?php endif; ?>
                                
                            
                            <?php elseif ($subfield->fieldname == 'nombre-del-archivo' && !empty($subfield->rawvalue)): ?>
                                <?php $nombreArchivo = $subfield->rawvalue; ?>
                                
                            <?php elseif ($subfield->fieldname == 'ruta-del-archivo' && !empty($subfield->rawvalue)): ?>
                                <?php $rutaArchivo = $subfield->rawvalue; ?>
                                
                            <?php endif; ?>
                        <?php endforeach; ?>
                        
                        <?php if (!empty($nombreArchivo) && !empty($rutaArchivo)): ?>
                            <?php $archivos[] = ['nombre' => $nombreArchivo, 'ruta' => $rutaArchivo]; ?>
                        <?php endif; ?>
                        
                    <?php endforeach; ?>
                <?php endif; ?>
            <?php endforeach; ?>  
        
        </div>
        
        
        <?php if (!empty($archivos)): ?>
            <div class="uk-margin-top">
                <h5>Descarga</h5>
                <?php foreach ($archivos as $archivo): ?>
                    <a href="<?php echo htmlspecialchars($archivo['ruta']); ?>" target="_blank">
                        <?php echo htmlspecialchars($archivo['nombre']); ?>
                    </a><br>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
    </div>
    
    <div class="right-side uk-width-3-5@l uk-width-3-5@m uk-width-1@s">
		<div class="title-container uk-width-1@m">
            <h5><?php echo $this->item->title ?></h5>
		</div>
		 <div class="item-date-cat uk-width-1">
			<div class="uk-grid">
                <div class="uk-width-1-2@m uk-text-left">
                    <?php echo LayoutHelper::render('joomla.content.info_block', ['item' => $this->item, 'params' => $params, 'position' => 'above']); ?>
                </div>
            </div>
		</div>
		<div class="content-container uk-width-1@m">
            
            <p class="item-content"><?php echo $this->item->introtext.$this->item->fulltext ?></p>
            
		</div>
		<div class="uk-panel item-social">
			
			<p>
                <span>COMPARTE</span>
            
                <!-- Facebook -->
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode($absolute_url); ?>" target="_blank" rel="noopener noreferrer">
                    <i uk-icon="icon: facebook" aria-hidden="true"></i>
                </a>
            
                <!-- Twitter -->
                <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode($absolute_url); ?>&text=<?php echo urlencode($this->item->title); ?>" target="_blank" rel="noopener noreferrer">
                    <i uk-icon="icon: twitter" aria-hidden="true"></i>
                </a>
            
                <!-- Email -->
                <a class="itemEmailLink" rel="nofollow" href="<?php echo $this->item->emailLink; ?>"
                    onclick="window.open(this.href,'emailWindow','width=400,height=350,location=no,menubar=no,resizable=no,scrollbars=no'); return false;">
                    <i uk-icon="icon: mail" aria-hidden="true"></i>
                </a>
            </p>
			
		</div> 
	</div>
</div>


<!-- 
    <div class="com-content-article uk-container item-page<?php echo $this->pageclass_sfx; ?>">
        <meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? Factory::getApplication()->get('language') : $this->item->language; ?>">
        <?php if ($this->params->get('show_page_heading')) : ?>
            <div class="page-header">
                <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
            </div>
        <?php endif;
        if (!empty($this->item->pagination) && !$this->item->paginationposition && $this->item->paginationrelative) {
            echo $this->item->pagination;
        }
        ?>

        <?php $useDefList = $params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
            || $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author') || $assocParam; ?>

        <?php if ($params->get('show_title')) : ?>
            <div class="page-header">
                <<?php echo $htag; ?>>
                    <?php echo $this->escape($this->item->title); ?>
                </<?php echo $htag; ?>>
                <?php if ($this->item->state == ContentComponent::CONDITION_UNPUBLISHED) : ?>
                    <span class="badge bg-warning text-light"><?php echo Text::_('JUNPUBLISHED'); ?></span>
                <?php endif; ?>
                <?php if ($isNotPublishedYet) : ?>
                    <span class="badge bg-warning text-light"><?php echo Text::_('JNOTPUBLISHEDYET'); ?></span>
                <?php endif; ?>
                <?php if ($isExpired) : ?>
                    <span class="badge bg-warning text-light"><?php echo Text::_('JEXPIRED'); ?></span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <?php if ($canEdit) : ?>
            <?php echo LayoutHelper::render('joomla.content.icons', ['params' => $params, 'item' => $this->item]); ?>
        <?php endif; ?>

        <?php // Content is generated by content plugin event "onContentAfterTitle" 
        ?>
        <?php echo $this->item->event->afterDisplayTitle; ?>

        <?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
            <?php echo LayoutHelper::render('joomla.content.info_block', ['item' => $this->item, 'params' => $params, 'position' => 'above']); ?>
        <?php endif; ?>

        <?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
            <?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>

            <?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
        <?php endif; ?>

        <?php // Content is generated by content plugin event "onContentBeforeDisplay" 
        ?>
        <?php echo $this->item->event->beforeDisplayContent; ?>

        <?php if ((int) $params->get('urls_position', 0) === 0) : ?>
            <?php echo $this->loadTemplate('links'); ?>
        <?php endif; ?>
        <?php if ($params->get('access-view')) : ?>
            <?php echo LayoutHelper::render('joomla.content.full_image', $this->item); ?>
            <?php
            if (!empty($this->item->pagination) && !$this->item->paginationposition && !$this->item->paginationrelative) :
                echo $this->item->pagination;
            endif;
            ?>
            <?php if (isset($this->item->toc)) :
                echo $this->item->toc;
            endif; ?>
            <div class="com-content-article__body">
                <?php echo $this->item->text; ?>
            </div>

            <?php if ($info == 1 || $info == 2) : ?>
                <?php if ($useDefList) : ?>
                    <?php echo LayoutHelper::render('joomla.content.info_block', ['item' => $this->item, 'params' => $params, 'position' => 'below']); ?>
                <?php endif; ?>
                <?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
                    <?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
                    <?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php
            if (!empty($this->item->pagination) && $this->item->paginationposition && !$this->item->paginationrelative) :
                echo $this->item->pagination;
            ?>
            <?php endif; ?>
            <?php if ((int) $params->get('urls_position', 0) === 1) : ?>
                <?php echo $this->loadTemplate('links'); ?>
            <?php endif; ?>
            <?php // Optional teaser intro text for guests 
            ?>
        <?php elseif ($params->get('show_noauth') == true && $user->get('guest')) : ?>
            <?php echo LayoutHelper::render('joomla.content.intro_image', $this->item); ?>
            <?php echo HTMLHelper::_('content.prepare', $this->item->introtext); ?>
            <?php // Optional link to let them register to see the whole article. 
            ?>
            <?php if ($params->get('show_readmore') && $this->item->fulltext != null) : ?>
                <?php $menu = Factory::getApplication()->getMenu(); ?>
                <?php $active = $menu->getActive(); ?>
                <?php $itemId = $active->id; ?>
                <?php $link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false)); ?>
                <?php $link->setVar('return', base64_encode(RouteHelper::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language))); ?>
                <?php echo LayoutHelper::render('joomla.content.readmore', ['item' => $this->item, 'params' => $params, 'link' => $link]); ?>
            <?php endif; ?>
        <?php endif; ?>
        <?php
        if (!empty($this->item->pagination) && $this->item->paginationposition && $this->item->paginationrelative) :
            echo $this->item->pagination;
        ?>
        <?php endif; ?>
        <?php // Content is generated by content plugin event "onContentAfterDisplay" 
        ?>
        <?php echo $this->item->event->afterDisplayContent; ?>
    </div> -->

    <style>
        .marg{
            margin: 2px 20px 20px 20px;
        }
    
        .img-container {
            align-self: flex-start !important;
        }

        .right-side {
            padding-top: 40px !important;
            padding-left: 40px !important;
        }

        .item-title-img {
            padding: 40px 0px 0 0 !important;
            align-self: flex-start;
        }
        .separator-with-border {
            border-bottom: 1px solid #ccc;
            padding-bottom: 15px;
            width: 100%;
            margin-bottom: 15px;
        }

        a.red-link,
        a.red-link:hover {
            color: #c62038
        }

        .item-title-img {
            padding: 40px 0px 0 0 !important;
        }

        .title-container h5 {
            color: #5f1b2d;
            line-height: 26px !important;
            margin-bottom: 20px;
        }

        .item-date-cat {
            border-top: 1px solid #dedde1;
            border-bottom: 1px solid #dedde1;
            padding: 4px 0;
            margin: 0 0 30px 0;
            color: #c19e74;
            font: 400 14px Poppins;
        }

        .item-content,
        .content-container {
            color: #575757;
            font: 400 16px Poppins;
        }

        .item-gallery-thumbs {
            padding: 0 0 20px 0 !important;
            margin: 0 !important;

        }

        @media all and (max-width: 479px) and (min-width: 300px) {
            .title-container h2 {
                font: normal 20px Montserrat-SemiBold;
            }

            .item-title-mobile {
                display: contents !important;
            }

            .title-container {
                display: none
            }
        }

        @media all and (max-width: 768px) and (min-width: 480px) {
            .right-side {
                padding-left: 0 !important;
            }

            .item-title-mobile {
                display: contents !important;
            }

            .title-container {
                display: none
            }
        }

        @media all and (max-width: 960px) and (min-width: 769px) {}

        @media all and (max-width: 1200px) and (min-width: 961px) {}
    </style>