<?php
/**
* ChronoForms8
* Copyright (c) 2025 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

class PlgSystemChronoforms8 extends Joomla\CMS\Plugin\CMSPlugin{
	public function onAfterRoute(){

	}
	
	public function onAfterDispatch(){

		if(!file_exists(JPATH_ROOT."/administrator/components/com_chronoforms8/extension.php")){
			return;
		}
		
		require_once(JPATH_ROOT."/administrator/components/com_chronoforms8/extension.php");

		$chrono_app = ChronoApp::Instance("chronoforms8");

		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		$buffer = $doc->getBuffer('component');
		
		$components = ['com_content'];

		if(!empty($chrono_app->settings["system_plugin_components"])){
			$components = $chrono_app->settings["system_plugin_components"];
		}
			
		if(!JFactory::getApplication()->isClient('administrator') AND in_array($app->input->get('option'), $components) AND $app->input->get('layout') != 'edit'){
			//match shortcodes
			$regexes = [
				'chronoforms8' => '#{chronoforms8}(.*?){/chronoforms8}#s',
			];
			
			$reg_capture = [
				'chronoforms8' => ['chronoform', 'chronopage'],
			];
			
			$reg_matches = [
				'chronoforms8' => ['chronoform'],
			];
			
			$reg_resets = [
				'chronoforms8' => ['chronoform' => ['chronopage']],
			];
			
			$reg_values = [];
			
			foreach($regexes as $ext => $regex){
				preg_match_all($regex, $buffer, $matches);
				
				if(!empty($reg_capture[$ext])){
					foreach($reg_capture[$ext] as $rck => $rcv){
						$reg_values[$rcv] = $chrono_app->data($rcv);
					}
				}
				
				if(!empty($matches[0])){
					foreach($matches[0] as $k => $match){
						ob_start();

						//check params
						if(!empty($matches[1][$k])){
							parse_str(html_entity_decode($matches[1][$k]), $params);
							
							if(!empty($reg_matches[$ext])){
								$params_keys = array_keys($params);
								foreach($reg_matches[$ext] as $rk => $rv){
									
									if(!empty($reg_values[$rv]) AND $reg_values[$rv] != $params_keys[$rk]){
										if(!empty($reg_resets[$ext][$rv])){
											foreach($reg_resets[$ext][$rv] as $rskey){
												$chrono_app->data($rskey, null, true);
											}
										}
									}else{
										if(!empty($reg_resets[$ext][$rv])){
											foreach($reg_resets[$ext][$rv] as $rskey){
												$chrono_app->data($rskey, $reg_values[$rskey] ?? null, true);
											}
										}
									}
									
									$chrono_app->data($rv, $params_keys[$rk], true);
								}
							}
							
							foreach($params as $pk => $pv){
								if(!is_null($pv)){
									$chrono_app->data($pk, $pv, true);
								}
							}
						}
						
						$chrono_app->processExtension(action:"view", params:["chronoform" => $chrono_app->data["chronoform"]]);
						$result = ob_get_clean();
						$buffer = str_replace($match, $result, $buffer);
					}
				}
			}
			
			$doc->setBuffer($buffer, 'component');
		}
	}
}