<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;


if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}



$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle(
    'mod_articles.oferta.style',
    'modules/mod_articles/tmpl/oferta/css/style.css'
);

?>
<div id="<?= 'oferta-' . $module->id ?>">
    <h2 class="uk-text-center c-727272" style="font-weight: 300"> <?= $module->title ?> </h2>
    <div class="uk-flex uk-flex-column uk-width-1-1">
        <div class="pa-tar">
            <div class="uk-child-width-1-2@s uk-child-width-1-3@m uk-text-center uk-grid-small uk-flex-center" uk-grid>
                <?php foreach($items as $item): ?>
                    <?php $img= json_decode($item->images); ?>
                    <div>
                        <a href="<?= $item->link ?>">
                        <div class="uk-card uk-card-body uk-flex uk-flex-center uk-flex-middle img-o uk-text-bold" style="background-image: url('<?=$img->image_intro ?>')"> <?= $item->title ?> </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

