<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;



if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle(
    'mod_articles.galeria.style', 
    'modules/mod_articles/tmpl/galeria/css/style.css' 
);

//Traer los alementos adjuntos, campos extras
// foreach ($items as &$item) {
    
//     print_r($item->fields = FieldsHelper::getFields('com_content.article', $item, true));
// }

function primerasPalabras($texto, $limite = 5) {
    // Dividir en palabras
    $palabras = explode(' ', strip_tags($texto));

    // Tomar solo las primeras $limite palabras
    $primeras = array_slice($palabras, 0, $limite);

    // Unirlas de nuevo en un string
    return implode(' ', $primeras) . '...';
}


?>

<div class="">    
    <div class="padding30">
        <div class="" uk-slider="autoplay: true; autoplay-interval: 3000">
            <div class="uk-margin-auto uk-slider-container uk-padding">
                <ul
                    class="uk-slider-items carrusel-image uk-child-width-1-4@l uk-child-width-1-4@m uk-child-width-1-2@s uk-child-width-1-1">
                    <?php foreach ($items as $item): ?>
                        
                    <?php $img= json_decode($item->images); ?>

                    <li class="slideshow-item uk-padding-small" tabindex="-1">

                        <div class="uk-container carrusel-width " style="width: auto; border-radius: 35px; display: flex; flex-direction: column;">

                            <a href="<?=$item->link?>" target="_blank" style="flex: 0 0 auto;">
                                <img style="border-radius: 35px; width: 200px; height: 200px; object-fit: cover;" alt="<?= $item->title ?>"
                                    src="<?=$img->image_intro ?>" class="" />
                            </a>
                            <div class="uk-text-center" style="flex: 0 0 auto; padding: 10px 0;">
                                <span tabindex="-1"><?= $item->title ?></span> <br>
                                <span tabindex="-1"><?= primerasPalabras($item->introtext) ?></span>
                            </div>

                        </div>
                        
                    </li>
                    <?php endforeach; ?>
                </ul>

            </div>

        </div>

        <div class="uk-padding-large">
            <div class="uk-flex uk-flex-center">
                <div class="grenn-buttonG"><a href="galeria" >Todas las <strong>galerías</strong></a></div>
            </div>
        </div>
    </div>
</div>


