<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;



if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->registerAndUseStyle(
    'mod_articles.galeria-lightbox.style', 
    'modules/mod_articles/tmpl/galeria-lightbox/css/style.css' 
);

//Traer los alementos adjuntos, campos extras
// foreach ($items as &$item) {
    
//     print_r($item->fields = FieldsHelper::getFields('com_content.article', $item, true));
// }

function primerasPalabras($texto, $limite = 5) {
    // Dividir en palabras
    $palabras = explode(' ', strip_tags($texto));

    // Tomar solo las primeras $limite palabras
    $primeras = array_slice($palabras, 0, $limite);

    // Unirlas de nuevo en un string
    return implode(' ', $primeras) . '...';
}


?>


<div class="uk-child-width-1-4@m" uk-grid uk-lightbox="nav: thumbnav; slidenav: false">
    <?php foreach ($items as $item): ?>
        <?php $img= json_decode($item->images); ?>
        <div>
            <a class="uk-inline" href="<?=$img->image_intro ?>" data-caption="Caption 3" data-attrs="class: uk-inverse-dark">
                <img src="<?=$img->image_intro ?>" width="1800" height="1200" alt="">
            </a>
        </div>
    <?php endforeach; ?>
    
</div>



