<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;



if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}


use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/faq/css/style.css');
//print_r($items); 
?>

<h2 class="uk-text-center uk-text-light uk-text-muted uk-margin-small-right">Preguntas frecuentes <span uk-icon="icon: question; ratio: 2"></span> </h2>

<ul uk-accordion>
    <?php foreach ($items as $item) : ?>
        
        <li class="uk-text-center">
            <a class="uk-accordion-title uk-text-bold img-without" href>        <?= $item->title; ?>            </a>
            <div class="uk-accordion-content uk-padding">
                  <?= $item->introtext; ?>                
            </div>
        </li>

    <?php endforeach; ?>
</ul>
