<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_accordion/css/style.css');
$iconPath = Uri::base() . 'modules/mod_accordion/icons/';

if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-bottom">' . $module->title . '</h2>';
}

if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

function renderAccordion($categories, $level = 0, $iconPath = '')
{
    echo '<div class="uk-accordion level-' . $level . '" uk-accordion>';

    foreach ($categories as $category) {
        echo '<div class="uk-accordion-item">';
        echo '<a class="uk-accordion-title" href="#">' . htmlspecialchars($category->title) . '</a>';
        echo '<div class="uk-accordion-content">';

        if (!empty($category->articles)) {
            echo '<ul class="uk-list uk-list-striped">';

            foreach ($category->articles as $article) {
                $urls = json_decode($article->urls);
                $urla = $urls->urla ?? '';
                $urlb = $urls->urlb ?? '';
                $icon = '';
                $href = '';
                $alt = '';

                if (!empty($urla)) {
                    $ext = strtolower(pathinfo($urla, PATHINFO_EXTENSION));
                    if ($ext === 'pdf') {
                        $icon = 'pdf.svg';
                        $alt = 'PDF';
                        $href = $urla;
                    }
                } elseif (!empty($urlb)) {
                    $icon = 'link.svg';
                    $alt = 'Enlace';
                    $href = $urlb;
                }

                echo '<li>';
                if (!empty($href)) {
                    echo '<a href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '" target="_blank" rel="noopener noreferrer">';
                    echo '<img src="' . $iconPath . $icon . '" alt="' . $alt . '" width="20" height="20" class="uk-margin-small-right uk-icon-img">';
                    echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                    echo '</a>';
                } else {
                    echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                }
                echo '</li>';
            }

            echo '</ul>';
        } else {
            echo '';
        }


        if (!empty($category->children)) {
            renderAccordion($category->children, $level + 1, $iconPath);
        }

        echo '</div></div>';
    }

    echo '</div>';
}

if (!empty($categories[0]->children)) {
    renderAccordion($categories[0]->children, 0, $iconPath);
}
