<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Component\Content\Site\Helper\RouteHelper;

class ModCategoriasJerarquiaHelper
{
    public static function getCategories($rootId = 1)
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select('id, parent_id, title, lft')
            ->from('#__categories')
            ->where('extension = "com_content" AND published = 1')
            ->order('lft ASC');

        $db->setQuery($query);
        $items = $db->loadObjectList();

        $categories = [];
        foreach ($items as $item) {
            $item->children = [];
            $item->articles = self::getArticles($item->id);
            $categories[$item->id] = $item;}
        

        $tree = [];
        foreach ($categories as $id => $cat) {
            if ($cat->parent_id > 1 && isset($categories[$cat->parent_id])) {
                $categories[$cat->parent_id]->children[] = $cat;
            }
        }

        if (isset($categories[$rootId])) {
            return [$categories[$rootId]];
        }

        return [];
    }

  protected static function getArticles($catid)
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select('id, title, catid, urls') 
            ->from('#__content')
            ->where('catid = ' . (int) $catid)
            ->where('state = 1')
            ->order('title ASC');

        $db->setQuery($query);
        return $db->loadObjectList();
    }
}
