<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

?>
<div class="uk-container">
    <h1 class="uk-text-center">Noticias</h1>
    <div class="uk-grid-small uk-child-width-1-3@s uk-flex-center uk-text-center uk-margin-large-top" uk-grid>
        <?php if (!empty($this->items)) : ?>
        <?php foreach ($this->items as $item) : ?>
        <div>
            <?php $images = json_decode($item->images); ?>
            <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                <img src="<?php echo htmlspecialchars($images->image_intro, ENT_QUOTES, 'UTF-8'); ?>" alt="">
            </a>
            

            <div class="itemcat-title">
                
                    <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                        <?php echo $item->title; ?>
                    </a>
                
            </div>

            <?php 
                    $max_palabras = 40; 
                    $texto_limpio = strip_tags($item->introtext);
                    $palabras = explode(" ", $texto_limpio);
                    //$palabras = explode(" ", $item->introtext);
                    $primera_parte = array_slice($palabras, 0, $max_palabras);
                    $resultado = implode(" ", $primera_parte);
                        ?>
            <div class="itemcat-desc">
                <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                    <?php echo $resultado . "..."; ?>
                </a>
                
            </div>

        </div>
        <?php endforeach; ?>
        <?php else : ?>
        <p>No hay artículos disponibles en esta categoría.</p>
        <?php endif; ?>
    </div>
</div>

<style>
    .itemcat-title, 
    .itemcat-title a,
    .itemcat-title:hover, 
    .itemcat-title a:hover 
    {
    padding: 5% 0;
    font: 600 18px 'Corra Montserra';
    color: #5f1b2d;
    text-align: justify;
    line-height: 22px;
    text-decoration: none; /* Evita subrayado en enlaces */
    }

    .itemcat-desc, 
    .itemcat-desc a,
    .itemcat-desc:hover,
    .itemcat-desc a:hover,
    itemcat-desc span, 
    .itemcat-desc em
    {
    margin-top: 10px;
    font: 400 16px 'Corra Montserra';
    color: #6b6b6b !important;
    text-align: justify;
    }

    

</style>