<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\RouteHelper;

// Create shortcuts to some parameters.
$params  = $this->item->params;
$canEdit = $params->get('access-edit');
$user    = $this->getCurrentUser();
$info    = $params->get('info_block_position', 0);
$htag    = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// Check if associations are implemented. If they are, define the parameter.
$assocParam        = (Associations::isEnabled() && $params->get('show_associations'));
$currentDate       = Factory::getDate()->format('Y-m-d H:i:s');
$isNotPublishedYet = $this->item->publish_up > $currentDate;
$isExpired         = !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;

?>

<div class="flags uk-container uk-flex uk-flex-right uk-flex-middle"></div>

<div class="item-container uk-grid">
    <div class="left-side item-title-img uk-width-1-1@l uk-width-1-1@m uk-width-1-1@s">
        <div>
            <div class="title-container uk-width-1@m">
                <h5><?php echo $this->item->title ?></h5>
            </div>
            <div class="item-date-cat uk-width-1">
                <div class="uk-grid">
                    <div class="uk-width-1-1@m uk-text-center"><?php echo $ef->value //echo $itemDate ?></div>
                </div>
            </div>
        </div>

        <div class="img-container uk-width-1@m uk-flex uk-flex-center">
            <?php echo LayoutHelper::render('joomla.content.full_image', $this->item); ?>
        </div>

        <div class="content-container uk-width-1@m uk-padding">
            <p class="item-content"><?php echo $this->item->introtext . $this->item->fulltext ?></p>
        </div>

        <h5> Ver Galería </h5>
        <div class="uk-child-width-1-4@xl uk-child-width-1-4@l uk-child-width-1-2@m uk-child-width-1-3@s uk-child-width-1-2@xs uk-flex uk-flex-center uk-margin-medium-bottom"
            uk-grid uk-lightbox="animation: slide">
            <?php foreach ($this->item->jcfields as $field) : ?>
                <?php
                $fr = json_decode($field->rawvalue);

                if ($fr) {
                    foreach ($fr as $row) {
                        if (isset($row->field8->imagefile)) {
                            $imageFull = $row->field8->imagefile;
                            $image     = strtok($imageFull, '#'); // quita lo de #joomlaImage
                            $alt       = $row->field8->alt_text ?? '';
                ?>
                            <div>
                                <a class="uk-inline" href="<?php echo htmlspecialchars($image); ?>" data-caption="<?php echo htmlspecialchars($alt); ?>">
                                    <img src="<?php echo htmlspecialchars($image); ?>" alt="<?php echo htmlspecialchars($alt); ?>">
                                </a>
                            </div>
                <?php
                        }
                    }
                }
                ?>
            <?php endforeach; ?>

        </div>
    </div>
</div>


<style>
 .title-container h5 {
  color: #5f1b2d;
  line-height: 26px !important;
  margin-bottom: 20px;
}
</style>