<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$article = $this->item;
$img     = json_decode($article->images);
$urls    = json_decode($article->urls);
$iconPath = Uri::base() . 'templates/puebla/html/com_content/article/icons/';

// Obtener campos extra
$fields = FieldsHelper::getFields('com_content.article', $article, true);
$fieldsMap = [];
foreach ($fields as $field) {
    $fieldsMap[$field->name] = $field;
}

// Función para traducir fecha
function traducirFecha($fechaISO) {
    $diasIngles = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
    $diasEspanol = ['lunes','martes','miércoles','jueves','viernes','sábado','domingo'];

    $mesesIngles = ['January','February','March','April','May','June','July','August','September','October','November','December'];
    $mesesEspanol = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];

    $fechaEn = date('d \d\e F \d\e Y H:i', strtotime($fechaISO));
    $fechaEs = str_replace($diasIngles, $diasEspanol, $fechaEn);
    $fechaEs = str_replace($mesesIngles, $mesesEspanol, $fechaEs);

    return $fechaEs;
}
?>

<div class="uk-container uk-margin-large-bottom uk-margin-large-top">
    <div class="uk-grid uk-child-width-1-2@m uk-grid-large" uk-grid>
        <!-- Imagen principal -->
        <div class="uk-flex uk-flex-left uk-flex-column" uk-lightbox="animation: slide">
            <div class="uk-card-media-left uk-cover-container">
               <?php if (!empty($img->image_intro)) : ?>
                    <a href="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" data-caption="<?= htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') ?>">
                        <img src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="<?= htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') ?>" uk-cover>
                    </a>
                <?php else : ?>
                    <div class="uk-placeholder uk-text-center">Sin imagen</div>
                <?php endif; ?>
                <canvas width="auto" height="750"></canvas>
            </div>
        </div>

        <!-- Contenido-->
        <div>
            <div class="uk-card uk-card-body uk-border-rounded">
                <!-- Título -->
                <h2 class="uk-card-title uk-text-bold c-af1731"><?= htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') ?></h2>

                <!-- Fecha de publicación -->
                <div class="uk-text-meta uk-margin-small-bottom">
                    <div class="c-c79b66"><?= traducirFecha($article->publish_up); ?></div>
                </div>

                <!-- Introtext -->
                <div class="uk-margin-small-top">
                    <?= HTMLHelper::_('content.prepare', $article->introtext); ?>
                </div>

                <!-- Campos -->
                <?php if (!empty($fieldsMap['tipo']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin">
                        <span class="c-c79b66 fs-1-2rem"><?= nl2br(htmlspecialchars($fieldsMap['tipo']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($fieldsMap['fecha']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                        <img src="<?= $iconPath ?>calendar.svg" alt="Fecha" width="33" height="20" class="uk-margin-small-right uk-icon-img">
                        <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['fecha']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($fieldsMap['horario']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                        <img src="<?= $iconPath ?>reloj.svg" alt="Horario" width="33" height="20" class="uk-margin-small-right uk-icon-img">
                        <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['horario']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($fieldsMap['direccion']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                        <img src="<?= $iconPath ?>location.svg" alt="Dirección" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                        <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['direccion']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($fieldsMap['telefono']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                        <img src="<?= $iconPath ?>telefono.svg" alt="Teléfono" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                        <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['telefono']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($fieldsMap['link']->rawvalue)) : ?>
                    <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                        <img src="<?= $iconPath ?>link.svg" alt="Link" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                        <a href="<?= htmlspecialchars($fieldsMap['link']->rawvalue, ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener noreferrer" class="uk-link-text">
                            <span class="fs-1rem"><?= htmlspecialchars($fieldsMap['link']->rawvalue, ENT_QUOTES, 'UTF-8') ?></span>
                        </a>
                    </div>
                <?php endif; ?>

                <?php if (!empty($urls->urla)) : ?>
                    <p>
                        <a href="<?= htmlspecialchars($urls->urla, ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener noreferrer">
                            <img src="<?= $iconPath ?>file-pdf.svg" width="35" height="25" class="uk-margin-small-right uk-icon-img">
                            <span class="c-861e34">Ver convocatoria</span>
                        </a>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

