<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/convocatoria/css/style.css');

// Ruta de íconos SVG
$iconPath = Uri::base() . 'modules/mod_articles/tmpl/convocatoria/icons/';
?>

<div class="boder bgc-41625b uk-padding uk-margin-remove">
	<div uk-slider="autoplay: true; autoplay-interval: 2000">
		<!-- Título y navegación del slider -->
		<div class="uk-grid uk-flex-middle" uk-grid>
			<div class="uk-width-expand">
				<div class="">	
					<h3 class="Titu-convoca"><?php echo $module->title; ?></h3>
				</div>
			</div>
			<div class="uk-width-auto">
				<ul class="uk-slider-nav uk-dotnav uk-flex-right"></ul>
			</div>
		</div>


		<!-- Slider principal -->
		<div class="uk-position-relative uk-margin-small">
			<div class="uk-slider-container">
				<ul class="uk-slider-items colors-items boder uk-grid-small uk-child-width-1-1@s uk-child-width-1-3@m uk-grid-match" uk-height-match="target: > li > a > .uk-card">
					<?php foreach ($items as $i): $img = json_decode($i->images); ?>  
						<li class="border">
						<!--	<a class="sin-subrayado" href="<?//php echo $i->link ?>">-->
								<a class="sin-subrayado" href="<?= $i->link . '?mod=convocatoria' ?>">
								<div class="uk-card uk-card-default uk-padding-small uk-height-1-1 uk-flex uk-flex-column">
									<div class="uk-inline uk-cover-container">
										<?php if (!empty($img->image_intro)) : ?>
											<img class="boder" src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="" uk-cover>
										<?php endif; ?>
										<canvas width="600" height="800"></canvas>
									</div>
									
									<div class="Titu-convoca uk-margin-small-top">
										<?php echo $i->title ?>
									</div>

									<div class="Des-convoca uk-margin-small-top">
										<?php
											$s = strip_tags($i->introtext);
											$s = substr($s, 0, 150);
											echo substr($s, 0, strrpos($s, ' '));
										?>
									</div>

									<div class="uk-margin-top uk-margin-auto-top">
										<p class="c-c79b66">Saber +</p>
									</div>
								</div>
							</a>
						</li>
					<?php endforeach; ?>
				</ul>

			</div>
		</div> 
	</div>

	<div class="uk-flex uk-flex-center uk-margin-top">
		<a class="button-convocatoria" href="/eventos" title="Todas las convocatorias">
			<span class="uk-text-normal">Todos los </span> <span class="uk-text-bold">eventos</span>		
		</a>
	</div>

	<?php if ($params->get('itemCustomLink')): ?>
	<div class="uk-flex uk-flex-center uk-margin-top">
		<a class="button-convocatoria" 
		   href="<?php echo $params->get('itemCustomLinkURL'); ?>" 
		   title="<?php echo htmlspecialchars($params->get('itemCustomLinkTitle')); ?>">
			<?php echo $params->get('itemCustomLinkTitle'); ?>
		</a>
	</div>
<?php endif; ?>

</div>




