<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

?>
<div class="uk-container">
    <h1 class="uk-text-center">Eventos</h1>
    <ul class="uk-grid-medium colors-items uk-margin uk-padding uk-child-width-1-3@m uk-grid-match" uk-grid>
        <?php if (!empty($this->items)) : ?>
            <?php foreach ($this->items as $i) : ?>
                <?php $img = json_decode($i->images); ?>
                <li class="border">
                    <a class="sin-subrayado" href="<?php echo Route::_(RouteHelper::getArticleRoute($i->slug, $i->catid)); ?>">
                        <div class="uk-card uk-card-default uk-padding-small uk-height-1-1 uk-flex uk-flex-column">
                        
                        <!-- Imagen -->
                        <div class="uk-inline uk-cover-container boder uk-height-medium">
                            <?php if (!empty($img->image_intro)) : ?>
                            <img src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="" uk-cover>
                            <?php endif; ?>
                            <canvas width="auto" height="500"></canvas>
                        </div>

                        <!-- Título -->
                        <div class="Titu-convoca uk-margin-small-top uk-text-bold">
                            <?= htmlspecialchars($i->title) ?>
                        </div>

                        <!-- Descripción -->
                        <div class="Des-convoca uk-margin-small-top">
                            <?php
                            $s = strip_tags($i->introtext);
                            $s = substr($s, 0, 150);
                            echo substr($s, 0, strrpos($s, ' '));
                            ?>
                        </div>

                        </div>
                    </a>
                </li>   
            <?php endforeach; ?>
        <?php else : ?>
            <p>No hay artículos disponibles en esta categoría.</p>
        <?php endif; ?>
    </ul>
</div>

<style>
    /*** Titulos ***/
.Titu-convoca{
    font-size: 1.5rem;
    font-weight: 500;
    padding:5px;
    color: white;
}

.Des-convoca{
    font-size: 1rem;
    font-weight: 300;
    padding-bottom:3px;
    color: white!important; 
    text-align: justify;
}

/*** Colors Card ***/
.colors-items li:nth-child(3n+1) .uk-card {
    background-color: #1b2d2d;
    border-radius: 20px;
    padding:20px;
    margin:5px;
}
.colors-items li:nth-child(3n+2) .uk-card {
    background-color: #152421;
    border-radius: 20px;
    padding:20px;
    margin:5px;
}

.colors-items li:nth-child(3n) .uk-card {
    background-color: #213432;
    border-radius: 20px;
    padding:20px;
    margin:5px;
}

.bgc-41625b{
    background-color: #41625b;
}

a {
    text-decoration: none;
}
a.sin-subrayado {
    text-decoration: none;
}

</style>