<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/convocatoria_category/css/style.css');

// Ruta de íconos SVG
$iconPath = Uri::base() . 'modules/mod_articles/tmpl/convocatoria_category/icons/';
?>

<div class="white-button uk-padding uk-text-center ">
    <div>
        <a class="uk-margin-medium-top" href="/sdr/index.php/resultados">
            Resultados de <strong>convocatorias</strong> 
        </a>
    </div>
</div>

<?php if ($module->showtitle) : ?>
  <h2 class="uk-text-center uk-margin-top"><?php echo $module->title; ?></h2>
<?php endif; ?>

<ul class="uk-grid-medium colors-items uk-margin uk-padding uk-child-width-1-3@m uk-grid-match" uk-grid>
  <?php foreach ($items as $i): $img = json_decode($i->images); ?>  
    <li class="border">
      <a class="sin-subrayado" href="<?= $i->link . '?mod=convocatoria_category' ?>">
        <div class="uk-card uk-card-default uk-padding-small uk-height-1-1 uk-flex uk-flex-column">
          
          <!-- Imagen -->
          <div class="uk-inline uk-cover-container boder uk-height-medium">
            <?php if (!empty($img->image_intro)) : ?>
              <img src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="" uk-cover>
            <?php endif; ?>
            <canvas width="auto" height="500"></canvas>
          </div>

          <!-- Título -->
          <div class="Titu-convoca uk-margin-small-top uk-text-bold">
            <?= htmlspecialchars($i->title) ?>
          </div>

          <!-- Descripción -->
          <div class="Des-convoca uk-margin-small-top">
            <?php
              $s = strip_tags($i->introtext);
              $s = substr($s, 0, 150);
              echo substr($s, 0, strrpos($s, ' '));
            ?>
          </div>

        </div>
      </a>
    </li>
  <?php endforeach; ?>
</ul>
