<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\RouteHelper;

/** @var \Joomla\Component\Content\Site\View\Article\HtmlView $this */
// Create shortcuts to some parameters.
$params  = $this->item->params;
$canEdit = $params->get('access-edit');
$user    = $this->getCurrentUser();
$info    = $params->get('info_block_position', 0);
$htag    = $this->params->get('show_page_heading') ? 'h2' : 'h1';

// Check if associations are implemented. If they are, define the parameter.
$assocParam        = (Associations::isEnabled() && $params->get('show_associations'));
$currentDate       = Factory::getDate()->format('Y-m-d H:i:s');
$isNotPublishedYet = $this->item->publish_up > $currentDate;
$isExpired         = !is_null($this->item->publish_down) && $this->item->publish_down < $currentDate;

$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName('params'))
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('id') . ' = ' . (int) $this->item->catid);
$db->setQuery($query);
$paramsJson = $db->loadResult();

if ($paramsJson) {
    $paramsI = json_decode($paramsJson);
    $catImage = $paramsI->image ?? '';
}

/*** ATENCIÓN */
/** Slider es ID 18, Plan de estudios es 11 y  */

?>

<div class="uk-margin-large-bottom">
    <div class="uk-height-medium uk-flex uk-flex-center uk-flex-middle uk-background-cover uk-light uk-position-relative br" 
         data-src="<?= "/" . $catImage ?>" uk-img>
        <h1 class="uk-text-bold uk-position-center-left uk-padding-small"><?= $this->item->category_title ?></h1>
        <img src="/images/ucips_logo_banner_interno_flotado.png" alt="Bienvenidos UCIPS" class="uk-position-center-right uk-padding-small" style="max-height:80%;">
    </div>

    <div class="uk-flex-middle uk-margin-large-top" uk-grid>
        <div class="uk-width-2-3@m">
            <h4><?= $this->item->title ?></h4>
            <p><?= $this->item->introtext ?></p>
        </div>
        <div class="uk-width-1-3@m">
            <div class="custom-slideshow">
                <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1" uk-slideshow="ratio: 9:9; animation: push">

                    <div class="uk-slideshow-items br">
                        <?php 
                            $fieldId = 18; // ID del subform
                            if (!empty($this->item->jcfields[$fieldId]->rawvalue)) {
                                $galleryData = json_decode($this->item->jcfields[$fieldId]->rawvalue, true);
                            
                                if (!empty($galleryData)) {
                                    foreach ($galleryData as $rowKey => $row) {
                                        foreach ($row as $fieldKey => $field) {
                                            if (!empty($field['imagefile'])) {
                                                $image = explode('#', $field['imagefile'])[0]; // limpia #joomlaImage
                                                echo "<div>";
                                                    echo '<img class="br" src="' . htmlspecialchars($image, ENT_QUOTES) . '" alt="' . htmlspecialchars($field['alt_text'] ?? '', ENT_QUOTES) . '" uk-cover>';
                                                echo "</div>";
                                            }
                                        }
                                    }
                                }
                            }
                        ?>
                    </div>

                    <!-- Navegación anterior/siguiente -->
                    <a class="uk-position-center-left uk-position-small uk-hidden-hover" href uk-slidenav-previous uk-slideshow-item="previous"></a>
                    <a class="uk-position-center-right uk-position-small uk-hidden-hover" href uk-slidenav-next uk-slideshow-item="next"></a>

                    <!-- Dot navigation -->
                    <ul class="uk-slideshow-nav uk-dotnav uk-flex-center uk-margin"></ul>

                </div>
            </div>
        </div>
    </div>

    <div class="uk-margin-large-top">
        <h4> Plan de estudios </h4>
        <?php 
            $fieldPlan = 11; //El id del plan de estudios 
            echo $this->item->jcfields[$fieldPlan]->rawvalue;
        ?>
        
    </div>

    <div class="uk-margin-large-top">
        <div class="uk-overflow-auto">
            <table class="uk-table uk-table-middle uk-table-divider">
                <?php $fieldSen = 12; //El id del semestre  ?>

                <?php if (!empty($this->item->jcfields[$fieldSen]->rawvalue)): ?>
                    <?php $data = json_decode($this->item->jcfields[$fieldSen]->rawvalue, true); ?>
                        <?php foreach ($data as $semestre): ?>
                            <?php $nombreSemestre = $semestre['field13']; ?>
                            <thead>
                                <tr>
                                    <th class="uk-width-small"> <strong><?= $nombreSemestre ?></strong> </th>                
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($semestre['field17'] as $materia): ?>
                                <?php 
                                    $numeroMateria = $materia['field14'];
                                    $nombreMateria = $materia['field15'];
                                    $descripcion   = $materia['field16'];            
                                ?>
                                
                                <tr>
                                    <td><?= $numeroMateria ?></td>
                                    <td><strong><?= $nombreMateria ?></strong> <?= $descripcion ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        <?php endforeach; ?>
                <?php endif; ?>

                
            </table>
        </div>
    </div>
</div>

<style>

    /* Filas impares (1, 3, 5...) */
tbody tr:nth-child(odd) td:first-child {
    background-color: #e1dbcd;
}
tbody tr:nth-child(odd) td:nth-child(2) {
    background-color: #f4ebda;
}

/* Filas pares (2, 4, 6...) */
tbody tr:nth-child(even) td:first-child {
    background-color: #dfd4c2;
}
tbody tr:nth-child(even) td:nth-child(2) {
    background-color: #f2e3cc;
}

 /* Solo dots del slideshow con clase custom-slideshow */
.custom-slideshow .uk-dotnav li a {
    background-color: #a77f8a;
}

.custom-slideshow .uk-dotnav li.uk-active a {
    background-color: #4f0016;
}


.br{
    border-radius: 50px;
}
</style>