<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Categories\Categories;

$doc = Factory::getDocument();
$iconPath = Uri::base() . 'modules/mod_switcher/icons/';
$doc->addStyleSheet(Uri::base() . 'modules/mod_switcher/css/style.css');

if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-bottom">' . htmlspecialchars($module->title) . '</h2>';
}

if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

// Colores para cada categoría
$colors = ['#6c9283', '#64887a', '#5b7b6e', '#526d64', '#476158'];

// Navbar completo como grid
echo '<div id="list_categorias" uk-sticky="offset: 140; end: .fins; media: true" class="uk-padding uk-padding-remove-left uk-padding-remove-right">';
echo '<ul class="uk-grid-collapse uk-child-width-1-4@m uk-child-width-1-4@s uk-child-width-1-4 uk-text-center" uk-grid style="list-style:none; margin:0; padding:0;">';

$index = 0;

foreach ($categories[0]->children as $category) {

    $catid = $category->id;

    $categoryObj = Categories::getInstance('Content')->get($catid);
    $params = $categoryObj->params;
    $params = json_decode($params);


    $color = $colors[$index % count($colors)];

    //echo '<li class="licat c'.$color .'" uk-animation-toggle" style="background-color:' . $color . '; --cat-color:' . $color . ';" data-color="' . $color . '">';
    echo '<li class="licat   c'.$color.'" style="background-color:' . $color . '; --cat-color:' . $color . ';" data-color="' . $color . '">';
    //echo '<a href="#" class="cat-link uk-display-block catacti uk-animation-scale-up" data-target="cat-' . $index . '" style="color:#fff; text-decoration:none; padding:10px;">';
    echo '<a href="#" class="cat-link uk-display-block catacti " data-target="cat-' . $index . '" style="height: 100px; color:#fff; text-decoration:none; padding:10px;">';

    if (!empty($params)) {
        echo '<img src="' . $params->image . '" alt="' . htmlspecialchars($category->title) . '" class="uk-margin-small-bottom" style="max-width:50px;opacity:0.8;">';
    }
    echo '<div class="uk-text-uppercase textm">' . htmlspecialchars($category->title) . '</div>';
    echo '</a>';
    echo '</li>';

    $index++;
}
echo '</ul>';
echo '</div>';

// Renderizar el contenido de cada categoría
$index = 0;
$db = Factory::getDbo();

foreach ($categories[0]->children as $category) {
    
    echo '<div id="cat-' . $index . '" class="cat-content accordion-content" style="display:none;">';

    $title = htmlspecialchars($category->title);
    $words = explode(' ', $title, 2);
    $first = $words[0] ?? '';
    $second = $words[1] ?? '';

    echo '<h3 class="uk-text-capitalize uk-text-center" style="font-size:20pt; color:#8d8d8d;">';
    echo '<span style="font-weight:300;">' . $first . '</span> ';
    if ($second) {
        echo '<span style="font-weight:700;">' . $second . '</span>';
    }
    echo '</h3>';

    // Cargar artículos completos de esta categoría
    $query = $db->getQuery(true)
        ->select($db->quoteName(['id', 'title', 'catid', 'images', 'urls']))
        ->from($db->quoteName('#__content'))
        ->where($db->quoteName('catid') . ' = ' . (int) $category->id)
        ->where($db->quoteName('state') . ' = 1')
        ->order($db->quoteName('ordering') . ' ASC');

    $db->setQuery($query);
    $articles = $db->loadObjectList();

    if (!empty($articles)) {
        echo '<div class="uk-grid-small uk-padding uk-padding-remove-bottom" uk-grid>';
        $n = 1;
        foreach ($articles as $article) {
        
            // Obtener imágenes del artículo
            $images = json_decode($article->images);
            $introImage = $images->image_intro ?? '';
            $fullImage  = $images->image_fulltext ?? '';
            $imageToShow = $introImage ?: $fullImage;

            // Estructura del grid
            if ($n == 1){
                echo '<div class="uk-width-1-1@m uk-width-1-1@s uk-text-center uk-padding">';
            } else {
                echo '<div class="uk-width-1-3@m uk-width-1-1@s uk-text-center uk-padding">';
            }
            $fields = FieldsHelper::getFields('com_content.article', $article);


            // Mostrar imagen si existe
            if ($imageToShow) {
                echo '<div class="uk-margin-small-bottom">';
                echo '<img src="' . htmlspecialchars($imageToShow, ENT_QUOTES, 'UTF-8') . '" alt="' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '" style="max-width:150px;">';
                echo '</div>';
            }

            // Mostrar título con enlace o texto
            if (!empty($href)) {
                echo '<a href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-flex uk-flex-middle uk-flex-center">';
                echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                echo '</a>';
            } else {
                echo '<span style="font-size:18px; font-weight:500;">' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</span>';
                echo '<br>';
                echo '<span style="font-size:18px; font-weight:500;">' . htmlspecialchars($fields[1]->value, ENT_QUOTES, 'UTF-8') . '</span>';
                echo '<br>';
                echo '<span style="font-size:18px; font-weight:500;">' . htmlspecialchars($fields[0]->value, ENT_QUOTES, 'UTF-8') . '</span>';
            }

            echo '</div>';
            $n++;
        }
        echo '</div>';
    }

    echo '</div>'; // fin contenido categoría
    $index++;
}

echo '<div uk-grid class="fins uk-margin-remove">
    <div class="uk-width-1-5 c-6c9283"></div>
    <div class="uk-width-1-5 c-64887a"></div>
    <div class="uk-width-1-5 c-5b7b6e"></div>
    <div class="uk-width-1-5 c-526d64"></div>
    <div class="uk-width-1-5 c-476158"></div>
</div>';
?>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const links = document.querySelectorAll(".cat-link");
    const contents = document.querySelectorAll(".cat-content");

    links.forEach(link => {
        link.addEventListener("click", function(e) {
            e.preventDefault();

            contents.forEach(c => c.style.display = "none");

            const target = document.getElementById(this.dataset.target);
            if (target) target.style.display = "block";

            links.forEach(l => {
                l.parentElement.classList.remove("uk-active");
                l.style.backgroundColor = "";
            });

            this.parentElement.classList.add("uk-active");
            const activeColor = this.parentElement.dataset.color;
            this.style.backgroundColor = activeColor;
            this.style.color = "#fff";
        });
    });

    if (links.length > 0) {
        links[0].click();
    }
});
</script>
