<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Categories\Categories;

$doc = Factory::getDocument();
$iconPath = Uri::base() . 'modules/mod_switcher/icons/';
$doc->addStyleSheet(Uri::base() . 'modules/mod_switcher/css/style.css');
$doc->addScript(Uri::base() . 'modules/mod_switcher/js/script.js');


if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-bottom">' . htmlspecialchars($module->title) . '</h2>';
}

if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

// Colores para cada categoría
$colors = ['#6c9283', '#64887a', '#5b7b6e', '#526d64', '#476158'];

// Navbar completo como grid
echo '<div id="list_categorias" uk-sticky="offset: 140; end: .fins; media: true" class="uk-padding uk-padding-remove-left uk-padding-remove-right">';
echo '<ul class="uk-grid-collapse uk-child-width-1-4@m uk-child-width-1-4@s uk-child-width-1-4 uk-text-center" uk-grid >';

$index = 0;

foreach ($categories[0]->children as $category) {

    $catid = $category->id;

    $categoryObj = Categories::getInstance('Content')->get($catid);
    $params = $categoryObj->params;
    $params = json_decode($params);

     $color = $colors[$index % count($colors)];

    echo '<li class="licat   c'.$color.'" style="background-color:' . $color . '; --cat-color:' . $color . ';" data-color="' . $color . '">';
    if ($category->title=="Organigrama")
       echo '<a target="_blank" href="http://52.141.80.208:5020/transparenciaxpuebla/images/Organigrama/organigrama.pdf" class="cat-link uk-display-block catacti " data-target="cat-' . $index . '" style="height: 100px; color:#fff; text-decoration:none; padding:10px;">';
    else 
        echo '<a href="#" class="cat-link uk-display-block catacti " data-target="cat-' . $index . '" style="height: 100px; color:#fff; text-decoration:none; padding:10px;">';
       

    if (!empty($params)) {
        echo '<img src="' . $params->image . '" alt="' . htmlspecialchars($category->title) . '" class="uk-margin-small-bottom" style="max-width:50px;opacity:0.8;">';
    }
    echo '<div class="uk-text-uppercase textm">' . htmlspecialchars($category->title) . '</div>';
    echo '</a>';
    echo '</li>';

    $index++;
}
echo '</ul>';


// Renderizar el contenido de cada categoría
function renderAccordion($categorias, $level = 0, $iconPath = '') {
    $index = 0;    
    
    foreach ($categorias as $category) 
    {
        
        echo '<div id="cat-' . $index . '" class="">';

        $title = htmlspecialchars($category->title);
        $words = explode(' ', $title, 2);
        $first = $words[0] ?? '';
        $second = $words[1] ?? '';
    
        /*echo '<h3 class="uk-text-capitalize uk-text-center" style="font-size:20pt; color:#8d8d8d;">';
        echo '<span style="font-weight:300;">' . $first . '</span> ';
        if ($second) {
            echo '<span style="font-weight:700;">' . $second . '</span>';
        }
        echo '</h3>'; Se omite porque ya lleva el título en el swith*/
        
        $db = Factory::getDbo();
        
        $query = $db->getQuery(true)
            ->select($db->quoteName(['id', 'title', 'catid', 'images', 'urls']))
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('catid') . ' = ' . (int) $category->id)
            ->where($db->quoteName('state') . ' = 1')
            ->order($db->quoteName('ordering') . ' ASC');

        $db->setQuery($query);
        $articles = $db->loadObjectList();
        
        echo "\n";
        
        if (!empty($articles)) {
            
            
            echo '<div class="uk-grid-small uk-padding uk-padding-remove-bottom" uk-grid>';
            
            $n = 1;
            foreach ($articles as $article) 
            {
            
                // Obtener imágenes del artículo
                $images = json_decode($article->images);
                $introImage = $images->image_intro ?? '';
                $fullImage  = $images->image_fulltext ?? '';
                $imageToShow = $introImage ?: $fullImage;
                $urls = json_decode($article->urls);
                
                //Se hará para que si tiene urlb,    se cree el acordeón para que separe por secciones y si tiene urla, se muestre el PDF como el organigrama
                
                if (!empty($urls->urla)){
                    if ($urls->urla=="/#")
                        echo '<span class="title-convoca uk-padding-remove"><strong>' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</strong></span>';
                    else {
                         echo '<a style="width:100%;" href=' . $urls->urla . ' target="_blank" rel="noopener noreferrer">';
                         echo '<img src="' . $iconPath . 'pdf.svg " class="' . 'pdf-c uk-margin-small-right uk-icon-img">';
                         echo '<span class="title-convoca uk-padding-remove">' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</span>';
                         echo '</a>'; //Se omite para que se muestre el PDF*/
                    }    
                    /*echo '<iframe src=' . $urls->urla . ' width="1400" height="800" ></iframe>';*/
                }
                elseif ($urls->urlb) {
                    echo '<iframe src=' . $urls->urlb . ' width="1400" height="800" ></iframe>';
                    
                    
                }
                else{
                    // Estructura del grid
                    if ($n == 1){
                        echo '<div class="uk-width-1-1@m uk-width-1-1@s uk-text-center uk-padding">';
                    } else {
                        echo '<div class="uk-width-1-3@m uk-width-1-1@s uk-text-center uk-padding">';
                    }
                    $fields = FieldsHelper::getFields('com_content.article', $article);
        
        
                    // Mostrar imagen si existe
                    if ($imageToShow) {
                        echo '<div class="uk-margin-small-bottom">';
                        echo '<img src="' . htmlspecialchars($imageToShow, ENT_QUOTES, 'UTF-8') . '" alt="' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '" style="max-width:150px;">';
                        echo '</div>';
                    }
        
                    // Mostrar título con enlace o texto
                    if (!empty($href)) {
                        echo '<a href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-flex uk-flex-middle uk-flex-center">';
                        echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                        echo '</a>';
                    } else {
                        echo '<span style="font-size:18px; font-weight:700;">' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</span>';
                        echo '<br>';
                        echo '<span style="font-size:18px; font-weight:500;">' . htmlspecialchars($fields[1]->value, ENT_QUOTES, 'UTF-8') . '</span>';
                        echo '<br>';
                        echo '<span style="font-size:18px; font-weight:500;">' . htmlspecialchars($fields[0]->value, ENT_QUOTES, 'UTF-8') . '</span>';
                    }
        
                    echo '</div>';
                }
    
                
                $n++;
            }
            echo '</div>';
        }
        
        if (!empty($category->children)) {
            renderAccordion($category->children, $level + 1);
        }
        
        echo '</div>'; // fin contenido categoría
        $index++;
        
    }
    
}

echo '<div class="uk-switcher uk-margin">';
if (!empty($categories[0]->children)) {
    renderAccordion($categories[0]->children, 0, $iconPath);
    
    // ----- EXPORTAR URLS Y TITULOS DE CATEGORÍAS A JS -----
    $exportData = [];
    
    foreach ($categories[0]->children as $category) {
        $catid = $category->id;
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(['title','urls']))
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('catid') . ' = ' . (int) $catid)
            ->where($db->quoteName('state') . ' = 1');
    
        $db->setQuery($query);
        $articles = $db->loadObjectList();
    
        $urlb = null;
        foreach($articles as $a){
            $urls = json_decode($a->urls);
            if (!empty($urls->urlb)){
                $urlb = $urls->urlb;
            }
        }
    
        $exportData[] = [
            'id'    => $catid,
            'title' => $category->title,
            'urlb'  => $urlb
        ];
    }
    
    $jsData = json_encode($exportData, JSON_UNESCAPED_UNICODE);
    $doc->addScriptDeclaration("window._categoriasSwitch = $jsData;");

}
echo '</div>';

echo '</div>';


echo '<div uk-grid class="fins uk-margin-remove">
    
    <div class="uk-width-1-4 c-64887a"></div>
    <div class="uk-width-1-4 c-5b7b6e"></div>
    <div class="uk-width-1-4 c-526d64"></div>
    <div class="uk-width-1-4 c-476158"></div>
</div>';
?>
