<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Categories\Categories;


$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/documento/css/style.css');
$iconPath = Uri::base() . 'modules/mod_articles/tmpl/documento/icons/';

$category = null;

if (!empty($items)) {
    $categoryId = $items[0]->catid;
    $categories = JCategories::getInstance('Content');
    $category = $categories->get($categoryId);
}
?>

<?php if (!empty($category)) : ?>
    <h1 class="category-name">
        <?= htmlspecialchars($category->title, ENT_QUOTES, 'UTF-8') ?>
    </h1>

    <?php if (!empty($category->description)) : ?>
        <div class="category-description">
            <?= $category->description; ?>
        </div>
    <?php endif; ?>
<?php endif; ?>

	<?php if ($params->get('itemCustomLink')): ?>
	<div class="uk-flex uk-flex-center uk-margin-top white-button">
		<a class=""
		   href="<?php echo $params->get('itemCustomLinkURL'); ?>" 
		   title="<?php echo htmlspecialchars($params->get('itemCustomLinkTitle')); ?>">
			<?php echo $params->get('itemCustomLinkTitle'); ?>
		</a>
	</div>
    <?php endif; ?>

<div class="document-list truncate-text">
    <?php foreach ($items as $item) : ?>   
        <?php $urls = json_decode($item->urls); ?>
        <p class="uk-margin-small-bottom">
            <?php
            $urla = isset($urls->urla) ? $urls->urla : '';
            $urlb = isset($urls->urlb) ? $urls->urlb : '';
            $icon = '';
            $href = '';
            $alt = '';
            $classSize = ''; 

            if (!empty($urla)) {
                $ext = strtolower(pathinfo($urla, PATHINFO_EXTENSION));

                switch ($ext) {
                    case 'pdf':
                        $icon = 'pdf.svg';
                        $alt = 'PDF';
                        $classSize = 'icon-pdf';
                        $href = $urla;
                        break;
                    case 'doc':
                    case 'docx':
                        $icon = 'word.svg';
                        $alt = 'Word';
                        $classSize = 'icon-word';
                        $href = $urla;
                        break;
                    case 'xls':
                    case 'xlsx':
                        $icon = 'excel.svg';
                        $alt = 'Excel';
                        $classSize = 'icon-excel';
                        $href = $urla;
                        break;
                    case 'ppt':
                    case 'pptx':
                        $icon = 'powerpoint.svg';
                        $alt = 'PowerPoint';
                        $classSize = 'icon-powerpoint';
                        $href = $urla;
                        break;
                }
            }

            if (empty($href) && !empty($urlb)) {
                $icon = 'link.svg';
                $alt = 'Enlace';
                $classSize = 'icon-link';
                $href = $urlb;
            }

            if (!empty($href)) :
            ?>
                <a href="<?= htmlspecialchars($href, ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener noreferrer">
                    <img src="<?= $iconPath . $icon ?>" alt="<?= $alt ?>" class="<?= $classSize ?> uk-margin-small-right uk-icon-img">
                    <span class="title-convoca uk-padding-remove"><?= htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8') ?></span>
                </a>
            <?php else : ?>
                <span class="title-convoca uk-padding-remove"><?= htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8') ?></span>
            <?php endif; ?>
        </p>
    <?php endforeach; ?>
</div>
