<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Categories\Categories;


$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_accordion/css/style.css');
$iconPath = Uri::base() . 'modules/mod_accordion/icons/';


if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

function renderAccordion($categories, $level = 0, $iconPath = '')
{
    echo '<div class="uk-accordion level-' . $level . '" uk-accordion="multiple: true">';

    foreach ($categories as $category) {
        $cat = Categories::getInstance('Content')->get($category->id);
        
        echo '<div class="uk-accordion-item ">';
        echo '<a class="uk-accordion-title " href="#">' . htmlspecialchars($category->title) . '</a>';
        echo '<div class="uk-accordion-content">';

        // ARTÍCULOS
        if (!empty($category->articles)) {
            echo '<ul class="uk-list uk-list-striped">';

            foreach ($category->articles as $article) {
                $articleTable = Table::getInstance('Content', 'JTable');
                $articleTable->load($article->id);

                $urls = json_decode($article->urls);
                $urla = $urls->urla ?? '';
                $urlb = $urls->urlb ?? '';
                $icon = 'link.svg';
                $href = '';
                $alt = 'Archivo';

                // Verificar archivo en urla
                if (!empty($urla)) {
                    $parsedUrl = parse_url($urla, PHP_URL_PATH);
                    $ext = strtolower(pathinfo($parsedUrl, PATHINFO_EXTENSION));

                    switch ($ext) {
                        case 'pdf':
                            $icon = 'pdf.svg'; $alt = 'PDF'; break;
                        case 'doc':
                        case 'docx':
                            $icon = 'word.svg'; $alt = 'Word'; break;
                        case 'xls':
                        case 'xlsx':
                            $icon = 'excel.svg'; $alt = 'Excel'; break;
                        case 'ppt':
                        case 'pptx':
                            $icon = 'ppt.svg'; $alt = 'PowerPoint'; break;
                    }
                    $href = $urla;
                }
                // Si no hay urla, revisar urlb
                elseif (!empty($urlb)) {
                    $icon = 'link.svg';
                    $alt = 'Enlace';
                    $href = $urlb;
                }

                // Render
                echo '<li>';
                if (!empty($href)) {
                    echo '<a href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '" target="_blank" rel="noopener noreferrer">';
                    echo '<img src="' . $iconPath . $icon . '" alt="' . $alt . '" width="20" height="20" class="uk-margin-small-right uk-icon-img">';
                    echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                    echo '</a>';
                } else {

                    echo '<ul uk-accordion="multiple: true">';
                        echo '<li class="">';
                            echo '<a class="uk-accordion-title" href>' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</a>';
                            echo '<div class="uk-text-justify uk-accordion-content">';
                            
                                echo $articleTable->introtext;
                            echo '</div>';
                        echo '</li>';
                    echo '</ul>';
                    

                }
                

                echo '</li>';
            }

            echo '</ul>';
        }elseif (!empty($cat->description)) {
            echo '<ul class="uk-list uk-list-striped">';
                echo '<li>';
                    echo $cat->description;
                echo '</li>';
            echo '</ul>';
        }

        // SUBCATEGORÍAS
        if (!empty($category->children)) {
            renderAccordion($category->children, $level + 1, $iconPath);
        }

        echo '</div></div>';
    }

    echo '</div>';
}

if (!empty($categories[0]->children)) {
    renderAccordion($categories[0]->children, 0, $iconPath);
}
?>
