<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModCategoriasJerarquiaHelper
{
    /**
     * Obtiene la jerarquía de categorías con sus artículos.
     */
    public static function getCategories($rootId = 1, $orderCol = 'a.title', $orderDir = 'ASC')
    {
        $db = Factory::getDbo();

        // Obtener todas las categorías publicadas de com_content
        $query = $db->getQuery(true)
            ->select('id, parent_id, title, lft')
            ->from('#__categories')
            ->where('extension = "com_content" AND published = 1')
            ->order('lft ASC');

        $db->setQuery($query);
        $items = $db->loadObjectList();

        // Construir arreglo de categorías
        $categories = [];
        foreach ($items as $item) {
            $item->children = [];
            $item->articles = self::getArticles($item->id, $orderCol, $orderDir);
            $categories[$item->id] = $item;
        }

        // Armar jerarquía
        foreach ($categories as $id => $cat) {
            if ($cat->parent_id > 1 && isset($categories[$cat->parent_id])) {
                $categories[$cat->parent_id]->children[] = $cat;
            }
        }

        // Retornar categoría raíz con su árbol completo
        return isset($categories[$rootId]) ? [$categories[$rootId]] : [];
    }

    /**
     * Obtiene los artículos de una categoría específica con orden configurable.
     */
    protected static function getArticles($catid, $orderCol = 'a.title', $orderDir = 'ASC')
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('a.id, a.title, a.catid, a.urls, a.introtext, a.fulltext')
            ->from('#__content AS a')
            ->where('a.catid = ' . (int) $catid)
            ->where('a.state = 1');

        // Si el usuario elige "random", usar RAND()
        if ($orderCol === 'random') {
            $query->order('RAND()');
        } else {
            // Evitar inyección SQL y asegurar orden válido
            $query->order($db->escape($orderCol . ' ' . $orderDir));
        }

        $db->setQuery($query);
        return $db->loadObjectList();
    }
}
