<?php
/**
 * @version    5.0
 * @package    ES
 * @author     donluismx@gmail.com
 * @copyright  Copyright (c) 2025. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Juri::base() . 'modules/mod_k2_content_denuncia/tmpl/Default/css/style.css');

$catid = $_REQUEST['catid'] ?? $params->get('category_id', '1');
$title = $params->get('title_page');

// Obtener el título de la categoría
$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName('title'))
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('id') . ' = ' . (int)$catid);
$db->setQuery($query);
$categoryTitle = $db->loadResult();

// Requerir el archivo helper para obtener los artículos
require_once(JPATH_BASE . '/modules/mod_k2_content_denuncia/helper.php');
$nullParams = null; // Se define una variable para pasar por referencia
$items = modK2ContentDenunciaHelper::getItems($nullParams, [$catid]);
$totalResults = modK2ContentDenunciaHelper::getTotalItems($nullParams, [$catid]);

?>
<div>
    <span class="catItemEditLink">
        <div class="edit-btn uk-padding uk-padding-remove-bottom">
            <a href="<?php echo JURI::base() ?>"><span class="uk-margin-small-right uk-icon" uk-icon="home"></span></a>
        </div>
    </span>
</div>

<div class="uk-padding">
    <?php if ($title != '') echo $title; ?>
</div>

<hr class="clear" />

<?php
if (isset($_REQUEST['catid'])) {
    echo "<div class='uk-container'>";
    echo "<h3 class='uk-text-center'>" . htmlspecialchars($categoryTitle) . "</h3>";
    echo "</div>";
?>
<h4 class="uk-text-center uk-text-uppercase" style="color:#5f1b2b;">Resultados totales: <?php echo $totalResults; ?>
</h4>
<div class="table-responsive uk-text-center">
    <table class="uk-table table-denuncias">
        <thead>
            <tr>
                <th>Sujeto Obligado</th>
                <th>Número del denunciante</th>
                <th>Estatus denuncia</th>
            </tr>
        </thead>
        <tbody>
            <?php
                if (!empty($items)) {
                    foreach ($items as $item) {
                ?>
            <tr>
                <td><?php echo htmlspecialchars($categoryTitle); ?></td>
                <td><?php echo htmlspecialchars($item->custom_fields['numero-de-expediente'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($item->custom_fields['estatus-denuncia'] ?? ''); ?></td>
            </tr>
            <?php
                    }
                } else {
                    ?>
            <tr>
                <td colspan="3">No se encontraron resultados</td>
            </tr>
            <?php
                }
                ?>
        </tbody>
    </table>
</div>
<?php
}
?>