<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/slider/css/style.css');
//$doc->addScript(\Joomla\CMS\Uri\Uri::base() . 'modules/mod_articles/tmpl/slider/js/script.js');

?>


<div uk-slider>

    <div class="uk-position-relative">

        <div class="uk-slider-container uk-light">
            <div class="uk-slider-items uk-width-1-1">
                <?php foreach ($items as $item) : ?>
                <?php  $img= json_decode($item->images); ?>
                <?php  $urls= json_decode($item->urls); ?>

                <div data-title="<?= htmlspecialchars($item->title) ?>" data-link="<?= htmlspecialchars($urls->urla) ?>">
                <a href="<?= $urls->urla ?>" target="_blank" tabindex="-1">
                    <img src="<?= $img->image_intro ?>" alt="<?= htmlspecialchars($item->title) ?>">
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>





    </div>

    <ul class="uk-slider-nav uk-dotnav uk-flex-center uk-margin"></ul>

</div>
<!-- Contenedor accesible invisible -->
<div id="slider-announcer" style="position: absolute; left: -9999px;" aria-live="polite" aria-atomic="true"></div>
</div>