<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Helper\TagsHelper;
use Joomla\CMS\Categories\Categories;

$document = Factory::getDocument();
$url = JUri::base() . 'templates/puebla/html/mod_articles/noticiasCss/style.css';

$document->addStyleSheet($url);
?>

<div uk-slider="autoplay: true; autoplay-interval: 4000">

    <div class="titulo-con-navegacion uk-padding uk-padding-remove-bottom">
        <h4 style="color: #9f9f9f">Noticias</h4>
        <ul class="uk-slider-nav uk-dotnav"></ul>
    </div>

    <div class="uk-position-relative uk-visible-toggle uk-light uk-margin-medium-left uk-margin-medium-right" tabindex="-1">
        <div class="uk-slider-items uk-child-width-1-1@xs uk-child-width-1-1@s uk-child-width-1-4@m uk-child-width-1-4@l uk-text-center" uk-grid>
            <?php foreach ($list as $index => $i) { ?>
                <?php 
                    $img = json_decode($i->images); 
                    $link = htmlspecialchars($i->link, ENT_COMPAT, 'UTF-8', false);
                    $title = htmlspecialchars($i->title, ENT_COMPAT, 'UTF-8', false);
                    $intro = strip_tags($i->introtext);
                    // Obtener la categoría del artículo
                $categoryObj = Categories::getInstance('Content')->get($i->catid);
                $categoryDesc = $categoryObj ? strip_tags($categoryObj->description) : 'Sin descripción disponible';
                $categoryTitle = $categoryObj ? $categoryObj->title : 'Categoría desconocida';
                ?>
                <div class="uk-position-relative uk-visible-toggle uk-light">
                    <div class="uk-card uk-card-hover uk-width-1-1@m br-35px uk-display-block uk-text-decoration-none">
                        <span tabindex="0"
                                class="uk-button uk-button-text uk-text-bold" 
                                style="color: #999; cursor: pointer;" 
                                uk-toggle="target: #modal-<?php echo $index; ?>">
                        <div class="uk-card-header">
                            <div class="uk-grid-small uk-flex-middle" uk-grid>
                                <div class="uk-width-auto">
                                    <div class="uk-inline">
                                        <img tabindex="0" class="br-35px" src="<?php echo $img->image_intro ?>"
                                            alt="<?php echo $title ?>" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        </span>
                        <span tabindex="0"
                                class="uk-button uk-button-text uk-text-bold" 
                                style="color: #999; cursor: pointer;" 
                                uk-toggle="target: #modal-<?php echo $index; ?>">
                        <div class="uk-card-body uk-padding-remove-bottom uk-padding-remove-top uk-text-justify">
                            <h5 class="uk-card-title uk-margin-remove" tabindex="0"><?php echo $title ?></h5>
                            <p tabindex="0" style="color: #999"><?php echo substr($intro, 0, 150) ?>...</p>
                        </div>
                        </span>
                        <div class="uk-card-footer uk-text-left">
                            <span tabindex="0"
                                class="uk-button uk-button-text uk-text-bold" 
                                style="color: #999; cursor: pointer;" 
                                uk-toggle="target: #modal-<?php echo $index; ?>">
                                Saber +
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Modal individual para cada noticia -->
                
                <div id="modal-<?php echo $index; ?>" class="uk-modal-container" uk-modal>
    <div class="uk-modal-dialog uk-modal-body">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <p><?php echo $categoryDesc; ?></p>
        <div class="uk-text-right">
                            <a href="<?php echo $link ?>" class="uk-button" style="color:#fff; background-color:#c62038">Ir al boletín</a>
                        </div>
    </div>
</div>
                
            <?php } ?>
        </div>
    </div>

    <div class="uk-padding-large">
        <div class="uk-flex uk-flex-center">
            <div class="green-button">
                <a href="#" id="btn-noticias">Todas las <strong>noticias</strong></a>
            </div>
        </div>
    </div>
    <!---modal--->
        <div id="modal-not" class="uk-modal-container" uk-modal>
    <div class="uk-modal-dialog uk-modal-body">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <p><?php echo $categoryDesc; ?></p>
        
    </div>
</div>
    <!---->
    
    
</div>
<style>
.uk-modal{
    z-index:10000;
}
</style>
<script>
  document.addEventListener("DOMContentLoaded", function() {
    const btnNoticias = document.getElementById("btn-noticias");
    const modalElement = document.querySelector("#modal-not");
    const modalInstance = UIkit.modal(modalElement);

    btnNoticias.addEventListener("click", function(e) {
      e.preventDefault();
      modalInstance.show();

      // Escuchar cuando el modal se cierra
      modalElement.addEventListener("hidden", function() {
        window.location.href = "noticias";
      }, { once: true }); // Se ejecuta solo una vez
    });
  });
</script>
