<?php
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$app = Factory::getApplication();
$input = $app->input;

// Detectar si viene del módulo con ?mod=convocatoria
$fromConvocatoria = $input->getCmd('mod') === 'convocatoria';

//echo ("Buenos días");

if ($fromConvocatoria) :

    // Mostrar tu vista personalizada
    $img = json_decode($this->item->images);
    $urls = json_decode($this->item->urls);
  //  $fields = FieldsHelper::getFields('com_content.article', $this->item, true);
$fields = FieldsHelper::getFields('com_content.article', (object)['id' => $this->item->id], true);

    // Mapear campos por nombre
    $fieldsMap = [];
    foreach ($fields as $field) {
        $fieldsMap[$field->name] = $field;
    }

    $iconPath = Uri::base() . 'modules/mod_articles/tmpl/convocatoria/icons/';
?>

    <div class="uk-container uk-margin">
        <div class="uk-card uk-card-default uk-card-hover uk-overflow-hidden uk-grid-collapse uk-child-width-1-3@m boder" uk-grid>

            <!-- Imagen -->
            <div class="uk-card-media-left uk-cover-container">
                <?php if (!empty($img->image_intro)) : ?>
                    <img src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="" uk-cover>
                <?php else : ?>
                    <div class="uk-placeholder uk-text-center">Sin imagen</div>
                <?php endif; ?>
                <canvas width="800" height="1000"></canvas>
            </div>


            <!-- Contenido -->
            <div class="uk-width-expand">
                <div class="uk-card-body">
                    <span class="title-convoca uk-padding-remove"><?= htmlspecialchars($this->item->title, ENT_QUOTES, 'UTF-8') ?></span>

                    <!-- Introtext -->
                    <div class="uk-margin-small-bottom"><?= $this->item->introtext ?></div>

                    <?php if (!empty($fieldsMap['tipo']->rawvalue)) : ?>
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <span class="subtitle-convoca"><?= nl2br(htmlspecialchars($fieldsMap['tipo']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($fieldsMap['fecha']->rawvalue)) : ?>
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <img src="<?= $iconPath ?>calendar.svg" alt="Fecha" width="33" height="20" class="uk-margin-small-right uk-icon-img">
                            <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['fecha']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($fieldsMap['direccion']->rawvalue)) : ?>
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <img src="<?= $iconPath ?>location.svg" alt="Dirección" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                            <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['direccion']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($fieldsMap['contacto']->rawvalue)) : ?>
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <img src="<?= $iconPath ?>telefono.svg" alt="Teléfono" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                            <span class="fs-1rem"><?= nl2br(htmlspecialchars($fieldsMap['contacto']->rawvalue, ENT_QUOTES, 'UTF-8')) ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($fieldsMap['link']->rawvalue)) : ?>
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <img src="<?= $iconPath ?>link.svg" alt="Link" width="35" height="20" class="uk-margin-small-right uk-icon-img">
                            <a href="<?= htmlspecialchars($fieldsMap['link']->rawvalue, ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener noreferrer" class="uk-link-text">
                                <span class="fs-1rem"><?= htmlspecialchars($fieldsMap['link']->rawvalue, ENT_QUOTES, 'UTF-8') ?> </span>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php
echo '<pre>';
print_r(json_decode($this->item->images));
print_r(json_decode($this->item->urls));
echo '</pre>';?>


                    <?php if (!empty($urls->urla)) : ?>
                        <p>
                            <a href="<?= htmlspecialchars($urls->urla, ENT_QUOTES, 'UTF-8') ?>" target="_blank" rel="noopener noreferrer">
                                <img src="<?= $iconPath ?>file-pdf.svg" width="35" height="25" class="uk-margin-small-right uk-icon-img">
                                <span class="c-861e34">Ver convocatoria</span>
                            </a>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

<?php
else :
    // Mostrar el diseño original de Joomla
    echo $this->item->text;
endif;
