<?php
define('_JEXEC', 1);
define('JPATH_BASE', dirname(dirname(dirname(dirname(__FILE__)))));
require_once(JPATH_BASE . '/includes/defines.php');
require_once(JPATH_BASE . '/includes/framework.php');

$app = JFactory::getApplication('site');
$app->initialise();

require_once(JPATH_BASE . '/modules/mod_k2_content_denuncia/helper.php');

$catid = $_POST['catid'];
$limit = $_POST['limit'];
$query = $_POST['query'];
$page = 1;

if ($_POST['page'] > 1) {
    $start = (($_POST['page'] - 1) * $limit);
    $page = $_POST['page'];
} else {
    $start = 0;
}

$items = modK2ContentDenunciaHelper::getItems(null, [$catid], $query, $limit, $start);
$total_rows = modK2ContentDenunciaHelper::getTotalItems(null, [$catid], $query);

$output = '
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Número de expediente</th>
                    <th>Nombre del denunciante</th>
                    <th>Estatus denuncia</th>
                </tr>
            </thead>
            <tbody>';

if ($total_rows > 0) {
    foreach ($items as $item) {
        $output .= '<tr>';
          $output .= '<td>' . htmlspecialchars($item->custom_fields['numero-de-expediente'] ?? '') . '</td>';
        $output .= '<td>' . htmlspecialchars($item->custom_fields['nombre-del-denunciante'] ?? '') . '</td>';
        $output .= '<td>' . htmlspecialchars($item->custom_fields['estatus-denuncia'] ?? '') . '</td>';
        $output .= '</tr>';
    }
} else {
    $output .= '<tr><td colspan="3">No se encontraron resultados</td></tr>';
}

$output .= '
            </tbody>
        </table>
    </div>';

$total_links = ceil($total_rows / $limit);
$page_link = '<ul class="pagination">';

if ($total_links > 1) {
    if ($page > 1) {
        $previous_page = $page - 1;
        $page_link .= '<li class="page-item"><a class="page-link" href="#" data-page_number="' . $previous_page . '">Anterior</a></li>';
    } else {
        $page_link .= '<li class="page-item disabled"><a class="page-link" href="#">Anterior</a></li>';
    }

    for ($i = 1; $i <= $total_links; $i++) {
        if ($i == $page) {
            $page_link .= '<li class="page-item active"><a class="page-link" href="#">' . $i . '</a></li>';
        } else {
            $page_link .= '<li class="page-item"><a class="page-link" href="#" data-page_number="' . $i . '">' . $i . '</a></li>';
        }
    }

    if ($page < $total_links) {
        $next_page = $page + 1;
        $page_link .= '<li class="page-item"><a class="page-link" href="#" data-page_number="' . $next_page . '">Siguiente</a></li>';
    } else {
        $page_link .= '<li class="page-item disabled"><a class="page-link" href="#">Siguiente</a></li>';
    }
}
$page_link .= '</ul>';

echo $output;
echo $page_link;
?>