<?php
/**
 * @version    5.0
 * @package    ES
 * @author     donluismx@gmail.com
 * @copyright  Copyright (c) 2025
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class modK2ContentDenunciaHelper
{
    public static function getCatTree($parentId)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title, alias, parent_id');
        $query->from('#__categories');
        $query->where('parent_id = ' . (int)$parentId . ' AND published = 1');
        $query->order('lft ASC');
        $db->setQuery($query);
        $cats = $db->loadObjectList();
        
        $tree = array();
        if (count($cats) > 0) {
            foreach ($cats as $c) {
                $c->childs = self::getCatTree($c->id);
                $tree[] = $c;
            }
        }
        return $tree;
    }

    public static function getItems(&$params, $categoryIds, $query = '', $limit = 50, $start = 0)
    {
        $db = Factory::getDbo();
        
        // Primera consulta: Obtener los artículos
        $queryJoomla = $db->getQuery(true);
        $queryJoomla->select('a.id, a.catid, a.title, a.created, a.alias, a.state, c.title AS category_title');
        $queryJoomla->from($db->quoteName('#__content', 'a'));
        $queryJoomla->join('LEFT', $db->quoteName('#__categories', 'c') . ' ON a.catid = c.id');
        $queryJoomla->where('a.state = 1'); // Solo artículos publicados
        $queryJoomla->where('a.catid IN (' . implode(',', array_map('intval', $categoryIds)) . ')');

        if (!empty($query)) {
            $queryJoomla->where($db->quoteName('a.title') . ' LIKE ' . $db->quote('%' . $db->escape($query, true) . '%'));
        }
        $queryJoomla->order($db->quoteName('a.created') . ' DESC');
        $db->setQuery($queryJoomla, $start, $limit);
        $items = $db->loadObjectList();
        
        if (empty($items)) {
            return [];
        }

        // Obtener los IDs de los artículos encontrados
        $itemIds = array_column($items, 'id');

        // Segunda consulta: Obtener todos los campos personalizados de los artículos
        $queryFields = $db->getQuery(true);
        $queryFields->select('v.item_id, f.name, v.value');
        $queryFields->from($db->quoteName('#__fields', 'f'));
        $queryFields->join('INNER', $db->quoteName('#__fields_values', 'v') . ' ON f.id = v.field_id');
        $queryFields->where($db->quoteName('v.item_id') . ' IN (' . implode(',', array_map('intval', $itemIds)) . ')');
        $db->setQuery($queryFields);
        $customFields = $db->loadObjectList();

        // Organizar los campos personalizados por item_id
        $fieldsByItemId = [];
        foreach ($customFields as $field) {
            if (!isset($fieldsByItemId[$field->item_id])) {
                $fieldsByItemId[$field->item_id] = [];
            }
            $fieldsByItemId[$field->item_id][$field->name] = $field->value;
        }

        // Combinar los artículos con sus campos personalizados
        foreach ($items as $item) {
            $item->custom_fields = $fieldsByItemId[$item->id] ?? [];
        }
        
        return $items;
    }

    public static function getTotalItems(&$params, $categoryIds, $query = '')
    {
        $db = Factory::getDbo();
        $queryJoomla = $db->getQuery(true);
        $queryJoomla->select('COUNT(*)');
        $queryJoomla->from($db->quoteName('#__content', 'a'));
        $queryJoomla->where('a.state = 1');
        $queryJoomla->where('a.catid IN (' . implode(',', array_map('intval', $categoryIds)) . ')');
        if (!empty($query)) {
            $queryJoomla->where($db->quoteName('a.title') . ' LIKE ' . $db->quote('%' . $db->escape($query, true) . '%'));
        }
        $db->setQuery($queryJoomla);
        return $db->loadResult();
    }
}