<?php
/**
 * @version    5.0
 * @package    ES
 * @author     donluismx@gmail.com
 * @copyright  Copyright (c) 2025. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Juri::base() . 'modules/mod_k2_content_aviso/tmpl/Default/css/style.css');

$catid = $_REQUEST['catid'] ?? $params->get('category_id', '1');
$title = $params->get('title_page');

// Obtener el título de la categoría
$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName('title'))
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('id') . ' = ' . (int)$catid);
$db->setQuery($query);
$categoryTitle = $db->loadResult();

// Requerir el archivo helper para obtener los artículos
require_once(JPATH_BASE . '/modules/mod_k2_content_aviso/helper.php');
$nullParams = null; // Se define una variable para pasar por referencia
$items = modK2ContentAvisoHelper::getItems($nullParams, [$catid]);
$totalResults = modK2ContentAvisoHelper::getTotalItems($nullParams, [$catid]);

?>

<div>
    <span class="catItemEditLink">
        <div class="edit-btn uk-padding uk-padding-remove-bottom">
            <a href="<?php echo JURI::base() ?>"><span class="uk-margin-small-right uk-icon" uk-icon="home"></span></a>
        </div>
    </span>
</div>

<div class="uk-padding">
    <?php if ($title != '') echo $title; ?>
</div>

<hr class="clear" />

<?php
if (isset($_REQUEST['catid'])) {
    echo "<div class='uk-container'>";
    echo "<h3 class='uk-text-center'>" . htmlspecialchars($categoryTitle) . "</h3>";
    echo "</div>";
?>
<h4 class="uk-text-center uk-text-uppercase" style="color:#5f1b2b;">Resultados totales: <?php echo $totalResults; ?>
</h4>

<div class="uk-card uk-card-default uk-card-body uk-width-1-1">
    <ul class="uk-list uk-list-divider">
        <?php
        if (!empty($items)) {
            foreach ($items as $item) {
                // Obtener el título del ítem
                $itemTitle = htmlspecialchars($item->title ?? 'Archivo sin título');

                // Decodificar la cadena JSON del campo personalizado
                $customFieldData = json_decode($item->custom_fields['archivo'] ?? '{}');

                $fileURL = '';
                if ($customFieldData && isset($customFieldData->imagefile)) {
                    // Extraer y limpiar la URL del archivo
                    $cleanPath = str_replace('joomlaImage://local-images/', '', $customFieldData->imagefile);
                    // Asegurar que la URL sea completa
                    $fileURL = JUri::base() . $cleanPath;
                    
                    // Opcional: Eliminar los parámetros de URL si existen
                    $fileURL = strtok($fileURL, '?');
                    // Opcional: Eliminar el ancla del enlace si existe
                    $fileURL = strtok($fileURL, '#');
                }
                
                // No mostramos el enlace si la URL está vacía
                if (!empty($fileURL)) {
        ?>
        <li>
            <a class="uk-link-toggle" href="<?php echo $fileURL; ?>" target="_blank"
                download="<?php echo $itemTitle; ?>.pdf">
                <span class="uk-margin-small-right" uk-icon="download"></span>
                <span class="uk-text-middle"><?php echo $itemTitle; ?></span>
            </a>
        </li>
        <?php
                }
            }
        } else {
        ?>
        <!--<li>No se encontraron archivos para descargar.</li>-->
        <?php
        }
        ?>
    </ul>
</div>
<?php
}
?>