<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$doc = Factory::getDocument();
$iconPath = Uri::base() . 'modules/mod_accordion/icons/';

if ($module->showtitle) {
    echo '<h2 class="uk-text-center uk-margin-bottom">' . htmlspecialchars($module->title) . '</h2>';
}

if (empty($categories)) {
    echo '<p>No hay contenido disponible.</p>';
    return;
}

// Colores para cada categoría
$colors = ['#c09760', '#9f7b4b', '#725630', '#624824', '#463215'];

// Navbar completo como grid
echo '<div id="list_categorias" class="uk-padding uk-padding-remove-left uk-padding-remove-right">';
echo '<ul class="uk-grid-collapse uk-child-width-1-5@m uk-child-width-1-5@s uk-text-center" uk-grid style="list-style:none; margin:0; padding:0;">';

$index = 0;
foreach ($categories[0]->children as $category) {
    $categoryImage = '';
    $titleLower = strtolower($category->title);
    if ($titleLower === 'dependencias') {
        $categoryImage = 'icon_dep.svg';
    } elseif ($titleLower === 'entidades') {
        $categoryImage = 'icon_entidades.svg';
    } elseif ($titleLower === 'colegios y universidades') {
        $categoryImage = 'icon_uni.svg';
    } elseif ($titleLower === 'fideicomisos') {
        $categoryImage = 'icon_fid.svg';
    } elseif ($titleLower === 'tribunal') {
        $categoryImage = 'icon_trib.svg';
    }

    $color = $colors[$index % count($colors)];

    echo '<li style="background-color:' . $color . ';">';
    echo '<a href="#" class="cat-link uk-display-block" data-target="cat-' . $index . '" style="color:#fff; text-decoration:none; padding:10px;">';
    if (!empty($categoryImage)) {
        echo '<img src="' . $iconPath . $categoryImage . '" alt="' . htmlspecialchars($category->title) . '" class="uk-margin-small-bottom" style="max-width:50px;opacity:0.8;">';
    }
    echo '<div class="uk-text-uppercase">' . htmlspecialchars($category->title) . '</div>';
    echo '</a>';
    echo '</li>';

    $index++;
}
echo '</ul>';
echo '</div>';

// Renderizamos el CONTENIDO de cada categoría en divs ocultos
$index = 0;
foreach ($categories[0]->children as $category) {
    echo '<div id="cat-' . $index . '" class="cat-content" style="display:none;">';
    $title = htmlspecialchars($category->title);
    $words = explode(' ', $title, 2);

    $first = $words[0] ?? '';
    $second = $words[1] ?? '';

    echo '<h3 class="uk-text-capitalize uk-text-center" style="font-size:20pt; color:#8d8d8d;">';
    echo '<span style="font-weight:300;">' . $first . '</span> ';
    if ($second) {
        echo '<span style="font-weight:700;">' . $second . '</span>';
    }
    echo '</h3>';

    // ARTÍCULOS
    if (!empty($category->articles)) {
        echo '<div class="uk-grid-small uk-padding" uk-grid>';
        foreach ($category->articles as $article) {
            $urls = json_decode($article->urls);
            $urla = $urls->urla ?? '';
            $urlb = $urls->urlb ?? '';
            $icon = 'link.svg';
            $href = '';
            $alt = 'Archivo';

            if (!empty($urla)) {
                $parsedUrl = parse_url($urla, PHP_URL_PATH);
                $ext = strtolower(pathinfo($parsedUrl, PATHINFO_EXTENSION));

                switch ($ext) {
                    case 'pdf':  $icon = 'pdf.svg'; $alt = 'PDF'; break;
                    case 'doc':
                    case 'docx': $icon = 'word.svg'; $alt = 'Word'; break;
                    case 'xls':
                    case 'xlsx': $icon = 'excel.svg'; $alt = 'Excel'; break;
                    case 'ppt':
                    case 'pptx': $icon = 'ppt.svg'; $alt = 'PowerPoint'; break;
                }
                $href = $urla;
            } elseif (!empty($urlb)) {
                $icon = 'link.svg';
                $alt = 'Enlace';
                $href = $urlb;
            }

            // Cada item ocupa 1/2 del grid
            echo '<div class="uk-width-1-2 uk-card-default uk-padding" style="height:50%">';
            if (!empty($href)) {
                echo '<a href="' . htmlspecialchars($href, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-flex uk-flex-middle">';
                echo htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8');
                echo '</a>';
            } else {
                echo '<strong>' . htmlspecialchars($article->title, ENT_QUOTES, 'UTF-8') . '</strong><br>';

     // 🔹 Extrafields dinámicos con iconos
$fields = FieldsHelper::getFields('com_content.article', $article);

if (!empty($fields)) {
    // Contenedor flex horizontal
    echo '<div class="uk-flex uk-flex-left uk-flex-middle uk-flex-wrap">';

    foreach ($fields as $field) {
        if (!empty($field->value)) { // 👈 Solo mostrar si tiene valor
            $value = trim(strtolower($field->title));

            if ($value === 'obligaciones') {
                echo '<a href="' . htmlspecialchars($field->value, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-margin-small-right uk-flex uk-flex-middle">';
                echo '<img src="images/Categorias/icon_obligaciones.svg" alt="Obligaciones" width="20" height="20" class="uk-margin-small-right uk-icon-img">';
                echo '<span>OBLIGACIONES</span></a>';
            }

            if ($value === 'denuncias') {
                echo '<a href="' . htmlspecialchars($field->value, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-margin-small-right uk-flex uk-flex-middle">';
                echo '<img src="images/Categorias/icon_denuncias.svg" alt="Denuncias" width="20" height="20" class="uk-margin-small-right">';
                echo '<span>DENUNCIAS</span></a>';
            }

            if ($value === 'avisos de privacidad') {
                echo '<a href="' . htmlspecialchars($field->value, ENT_QUOTES, 'UTF-8') . '" target="_blank" class="uk-margin-small-right uk-flex uk-flex-middle">';
                echo '<img src="images/Categorias/icon_privacidad.svg" alt="Avisos de privacidad" width="20" height="20" class="uk-margin-small-right uk-icon-img">';
                echo '<span>AVISOS DE PRIVACIDAD</span></a>';
            }
        }
    }

    echo '</div>'; // Fin contenedor flex
}

            }
            echo '</div>';
        }
        echo '</div>';
    }

    // SUBCATEGORÍAS
    if (!empty($category->children)) {
        echo '<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>';
        foreach ($category->children as $child) {
            echo '<div><strong>' . htmlspecialchars($child->title) . '</strong></div>';
        }
        echo '</div>';
    }

    echo '</div>'; // fin contenido categoría
    $index++;
}
?>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const links = document.querySelectorAll(".cat-link");
    const contents = document.querySelectorAll(".cat-content");

    links.forEach(link => {
        link.addEventListener("click", function(e) {
            e.preventDefault();

            contents.forEach(c => c.style.display = "none");

            const target = document.getElementById(this.dataset.target);
            if (target) target.style.display = "block";

            links.forEach(l => l.parentElement.classList.remove("uk-active"));
            this.parentElement.classList.add("uk-active");
        });
    });

    if (links.length > 0) {
        links[0].click();
    }
});
</script>