<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}
?>

<div class="uk-container">
    <ul
        class="uk-list mod-articles-items<?php echo ($params->get('articles_layout') == 1 ? ' mod-articles-grid ' . $gridCols : ''); ?> mod-list">
        <?php foreach ($items as $item) : ?>
        <?php
            // Obtener campos personalizados del artículo
            $fields = FieldsHelper::getFields('com_content.article', $item, true);

            // Inicializar la URL
            $pdfUrl = '';

            // Buscar el campo deseado (por nombre)
            foreach ($fields as $field) {
                
                if ($field->name === 'ruta-archivo') {
                    
                    $pdfUrl = $field->rawvalue;
                    break;
                }
            }

            // Asegurar que la URL tenga el esquema correcto
            if (!empty($pdfUrl) && strpos($pdfUrl, 'http') !== 0) {
                $pdfUrl = JUri::root() . ltrim($pdfUrl, '/');
            }
        ?>
        <li>
            <a href="<?php echo htmlspecialchars($pdfUrl); ?>" download>
                <img src="images/icons/pdf-file.svg" width="3%">
                <?php echo $item->title; ?>
            </a>
        </li>
        <?php endforeach; ?>
    </ul>
</div>