<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
?>
<div class="uk-container">
    <h1 class="uk-text-center">Noticias</h1>
    <div class="uk-grid-small uk-child-width-1-3@s uk-flex-center uk-text-center uk-margin-large-top uk-padding uk-padding-remove-top" uk-grid>
        <?php if (!empty($this->items)) : ?>
            <?php foreach ($this->items as $item) : ?>
                <div>
                    <?php 
                        $images = json_decode($item->images);
                        $articleLink = Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid));
                    ?>

                    <?php if (!empty($images->image_intro)) : ?>
                        <a href="<?php echo $articleLink; ?>">
                            <img src="<?php echo htmlspecialchars($images->image_intro, ENT_QUOTES, 'UTF-8'); ?>" alt="">
                        </a>
                    <?php endif; ?>

                    <div class="itemcat-title">
                        <a href="<?php echo $articleLink; ?>">
                            <?php echo htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8'); ?>
                        </a>
                    </div>

                    <?php 
                        $max_palabras = 40; 
                        $palabras = explode(" ", strip_tags($item->introtext));
                        $primera_parte = array_slice($palabras, 0, $max_palabras);
                        $resultado = implode(" ", $primera_parte);
                    ?>
                    <div class="itemcat-desc">
                        <a href="<?php echo $articleLink; ?>">
                            <?php echo $resultado . "..."; ?>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else : ?>
            <p>No hay artículos disponibles en esta categoría.</p>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Títulos */
    .itemcat-title, 
    .itemcat-title a,
    .itemcat-title:hover, 
    .itemcat-title a:hover {
        padding: 5% 0;
        font: 600 18px 'Montserrat', sans-serif;
        color: #5f1b2d;
        text-align: justify;
        line-height: 22px;
        text-decoration: none;
    }

    /* Descripción */
    .itemcat-desc, 
    .itemcat-desc a,
    .itemcat-desc:hover,
    .itemcat-desc a:hover,
    .itemcat-desc span, 
    .itemcat-desc em {
        margin-top: 10px;
        font: 400 16px 'Montserrat', sans-serif;
        color: #6b6b6b !important;
        text-align: justify;
    }

    /* Imágenes uniformes */
    .uk-grid-small img {
        width: 100%;
        height: 200px;
        object-fit: cover;
        border-radius: 8px;
    }
</style>
