<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Date\Date;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

// Función para convertir link de YouTube a formato embed
function convertirYoutubeAEmbed($url) {
    if (strpos($url, 'youtube.com/watch?v=') !== false) {
        parse_str(parse_url($url, PHP_URL_QUERY), $params);
        return isset($params['v']) ? 'https://www.youtube.com/embed/' . $params['v'] : $url;
    }
    if (strpos($url, 'youtu.be/') !== false) {
        $videoId = basename($url);
        return 'https://www.youtube.com/embed/' . $videoId;
    }
    return $url;
}
?>

<div class="uk-container">
    <?php foreach ($items as $item) : ?>
    <?php
        // Cargar los campos personalizados
        $item->jcfields = FieldsHelper::getFields('com_content.article', $item, true);

        // Formato de fecha
        $date = new Date($item->publish_up);
        $fechaFormateada = HTMLHelper::_('date', $date, 'l, d F Y H:i');
        $fechaFormateada = Text::_($fechaFormateada);

        // Resumen de 200 caracteres
        $introResumen = HTMLHelper::_('string.truncate', strip_tags($item->introtext), 200, true, false);

        // Obtener campo extra llamado 'link'
        $extraLink = '';
        foreach ($item->jcfields as $field) {
            if ($field->name === 'link') {
                $extraLink = $field->value;
                break;
            }
        }

        // Convertir el link a embed si es YouTube
        $embedLink = !empty($extraLink) ? convertirYoutubeAEmbed($extraLink) : '';
    ?>
    <div class="uk-grid-small uk-child-width-1-2@m uk-flex-middle" uk-grid
        style="box-shadow: 0 5px 15px rgba(0, 0, 0, .08);">
        <div class="uk-padding-remove">
            <?php if (!empty($embedLink)) : ?>
            <iframe src="<?= htmlspecialchars($embedLink); ?>" width="100%" height="250px" frameborder="0"
                allowfullscreen></iframe>
            <?php else : ?>
            <div class="uk-placeholder uk-text-center">Sin enlace disponible</div>
            <?php endif; ?>
        </div>
        <div class="uk-card-body">
            <a class="uk-text-left" href="<?php echo $item->link ?>">
                <h3 class="uk-text-left uk-padding-remove" style="color:#C62038">
                    <?php echo htmlspecialchars($item->title); ?>
                </h3>
            </a>
            <p class="uk-text-left"><?php echo $fechaFormateada; ?></p>
            <p class="uk-text-justify"><?php echo $introResumen; ?></p>
        </div>
    </div>
    <?php endforeach; ?>
</div>