<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/slider/css/style.css');
$doc->addScript(\Joomla\CMS\Uri\Uri::base() . 'modules/mod_articles/tmpl/slider/js/script.js');

?>

<div>
    <div id="accesible-slideshow" class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1"
        uk-slideshow="animation: pull; autoplay: true; autoplay-interval: 5000;">

        <div class="uk-slideshow-items">

            <?php foreach ($items as $item) : ?>

            <?php  $img= json_decode($item->images); ?>
            <?php  $urls= json_decode($item->urls); ?>



            <div class="img-slider" data-title="<?= htmlspecialchars($item->title) ?>" data-link="<?= htmlspecialchars($urls->urla) ?>">

                <a href="<?= $urls->urla ?>" target="_blank"  tabindex="-1">
                    <img class="img-sli" src="<?= $img->image_intro ?>" alt="<?= htmlspecialchars($item->title) ?>" uk-cover>
                </a>
            </div>

            <?php endforeach; ?>
        </div>

        <a class="uk-position-center-left uk-position-small uk-hidden-hover" href uk-slidenav-previous
            uk-slideshow-item="previous"></a>
        <a class="uk-position-center-right uk-position-small uk-hidden-hover" href uk-slidenav-next
            uk-slideshow-item="next"></a>

    </div>
<!-- Contenedor accesible invisible -->
<div id="slider-announcer" style="position: absolute; left: -9999px;" aria-live="polite" aria-atomic="true"></div>
</div>