document.addEventListener('DOMContentLoaded', () => {
  const slider = document.getElementById('accesible-slideshow');
  const ukSlider = UIkit.slideshow(slider);
  const slides = slider.querySelectorAll('.uk-slideshow-items > div');
  const announcer = document.getElementById('slider-announcer');

  slider.addEventListener('focusin', () => ukSlider.stopAutoplay());
  slider.addEventListener('focusout', () => ukSlider.startAutoplay());

  slider.addEventListener('keydown', (e) => {
    if (e.key === 'Tab') {
      const currentIndex = ukSlider.index;
      const totalSlides = slides.length;

      if (e.shiftKey) {
        if (currentIndex === 0) return;
        e.preventDefault();
        ukSlider.show('previous');
      } else {
        if (currentIndex === totalSlides - 1) return;
        e.preventDefault();
        ukSlider.show('next');
      }
    }
  });

  function announceCurrentSlide() {
    const activeSlide = slider.querySelector('.uk-slideshow-items > div.uk-active');
    if (!activeSlide) {
      //console.warn('No se encontró slide activo');
      return;
    }

    const title = activeSlide.getAttribute('data-title') || 'Sin título';
    const link = activeSlide.getAttribute('data-link') || '';

    announcer.textContent = `Slide actual: ${title}. Enlace: ${link}`;
   // console.log('Anunciando:', announcer.textContent);
  }

  slider.addEventListener('aftershow', announceCurrentSlide);
  announceCurrentSlide();
});