<?php
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use Joomla\CMS\Date\Date;

?>
<div class="uk-container">
    <?php foreach ($items as $item) : ?>
    <?php
        //get image
        $images = json_decode($item->images);
        $introImage = isset($images->image_intro) ? $images->image_intro : '';

       //Date format
        $date = new Date($item->publish_up);
        $fechaFormateada = HTMLHelper::_('date', $date, 'l, d F Y H:i');
        $fechaFormateada = Text::_($fechaFormateada);

       //only 200 words 
        $introResumen = HTMLHelper::_('string.truncate', strip_tags($item->introtext), 200, true, false);
        ?>
    <div class="uk-grid-small uk-child-width-1-2@m uk-flex-middle  " uk-grid style="box-shadow: 0 5px 15px rgba(0, 0, 0, .08);
}">
        <div class="uk-padding-remove">
            <?php if (!empty($introImage)) : ?>
            <img src="<?php echo htmlspecialchars($introImage); ?>" alt="<?php echo htmlspecialchars($item->title); ?>"
                class="uk-width-expand" />
            <?php endif; ?>
        </div>
        <div class="uk-card-body">
            <a class="uk-text-left" href="<?php echo $item->link ?>">
                <h3 class="uk-text-left uk-padding-remove" style="color:#C62038">
                    <?php echo htmlspecialchars($item->title); ?></h3>
            </a>
            <p class="uk-text-left "><?php echo $fechaFormateada; ?></p>
            <p class="uk-text-justify "><?php echo $introResumen; ?></p>
        </div>
    </div>

    <?php endforeach; ?>
</div>