<?php
defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;
?>

<div class="uk-container uk-padding uk-padding-top-remove">

    <?php if (!empty($this->items)) : ?>
    <h2 class="uk-text-center uk-padding-small uk-margin-remove">
        <?php echo htmlspecialchars($this->items[0]->category_title); ?>
    </h2>
    <?php endif; ?>

    <?php if (!empty($this->items)) : ?>
    <div class="uk-grid uk-child-width-1-2@m uk-grid-match uk-margin " uk-grid>
        <?php foreach ($this->items as $item) : ?>
        <?php 
                    $images = json_decode($item->images); 

                    // Detectar si se debe mostrar el introtext
                    $showIntro = isset($item->params)
                        ? (int) $item->params->get('show_intro', 1)
                        : (int) $params->get('show_introtext', 1);
                ?>
        <div>
            <!-- Tarjeta interna con imagen y texto en 2 columnas -->
            <div class="uk-grid-small uk-child-width-expand@s uk-flex-middle" uk-grid>
                <!-- Columna imagen -->
                <div class="uk-width-1-2@s">
                    <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                        <img src="<?php echo htmlspecialchars($images->image_intro ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                            alt="<?php echo htmlspecialchars($item->title); ?>" style="width:100%; height:auto;">
                    </a>
                </div>

                <!-- Columna contenido -->
                <div class="uk-width-1-2@s">
                    <h3 class="itemcat-title uk-margin-remove">
                        <?php echo $item->title; ?>
                    </h3>

                    <?php if ($showIntro) : ?>
                    <?php
                                    $max_palabras = 40;
                                    $palabras = explode(" ", strip_tags($item->introtext));
                                    $primera_parte = array_slice($palabras, 0, $max_palabras);
                                    $resultado = implode(" ", $primera_parte);
                                ?>
                    <div class="itemcat-desc">
                        <p><?php echo $resultado . "..."; ?></p>
                    </div>
                    <?php endif; ?>

                    <a class="uk-button uk-button-text uk-align-right"
                        href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid)); ?>">
                        Más información &rarr;
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else : ?>
    <p>No hay artículos disponibles en esta categoría.</p>
    <?php endif; ?>
</div>

<style>
.itemcat-title {
    color: #5f1b2d;
}

.itemcat-title a {
    font: 600 20px 'Corra Montserra';
    color: #5f1b2d;
    text-decoration: none;
}

.itemcat-title a:hover {
    text-decoration: underline;
}

.itemcat-desc {
    font: 400 16px 'Corra Montserra';
    color: #6b6b6b;
    text-align: justify;
    margin-top: 10px;
}
</style>