<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_menu
 *
 * @copyright   (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'templates/puebla/html/mod_menu/css/style.css');





$attributes = [];
$attributes['class'] = 'uk-nav uk-nav-default uk-nav-parent-icon uk-padding ';
$attributes['uk-nav'] = 'multiple: true';

?>

<ul <?php echo ArrayHelper::toString($attributes); ?>>
<?php foreach ($list as $item) : ?>
    <?php
    $itemParams = $item->getParams();
    $classes = [];

    if ($item->deeper) {
        $classes[] = 'uk-parent';
    }
   echo '<li class="' . implode(' ', $classes) . '" style="padding: 2px;">';


    // Mostrar ícono si tiene, luego el texto
    $icon = $itemParams->get('menu_image');
    if ($icon) {
        $imgClass = $itemParams->get('menu_image_css', 'uk-margin-small-right');
        echo '<a href="' . $item->flink . '"><img src="' . $icon . '" class="' . $imgClass . '" alt="">';
        echo $item->title . '</a>';
    } else {
        echo '<a href="' . $item->flink . '">' . $item->title . '</a>';
    }

    // Submenú
    if ($item->deeper) {
        echo '<ul class="uk-nav-sub">';
    } elseif ($item->shallower) {
        echo '</li>';
        echo str_repeat('</ul></li>', $item->level_diff);
    } else {
        echo '</li>';
    }
    ?>
<?php endforeach; ?>
</ul>
