<?php
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;

// Variables base
$absolute_url = Uri::current();
$articleTitle = $this->escape($this->item->title);
$imageData = json_decode($this->item->images);
$introText = $this->item->introtext;
$fields = $this->item->jcfields;

// Función para traducir fecha
function traducirFecha($fechaISO) {
    $diasIngles = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
    $diasEspanol = ['lunes','martes','miércoles','jueves','viernes','sábado','domingo'];
    $mesesIngles = ['January','February','March','April','May','June','July','August','September','October','November','December'];
    $mesesEspanol = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];

    $fechaEn = date(' d \d\e F \d\e Y H:i', strtotime($fechaISO));
    $fechaEs = str_replace($diasIngles, $diasEspanol, $fechaEn);
    $fechaEs = str_replace($mesesIngles, $mesesEspanol, $fechaEs);

    return $fechaEs;
}

// Función para convertir link de YouTube a formato embed
function convertirYoutubeAEmbed($url) {
    if (strpos($url, 'youtube.com/watch?v=') !== false) {
        parse_str(parse_url($url, PHP_URL_QUERY), $params);
        return isset($params['v']) ? 'https://www.youtube.com/embed/' . $params['v'] : $url;
    }
    if (strpos($url, 'youtu.be/') !== false) {
        $videoId = basename($url);
        return 'https://www.youtube.com/embed/' . $videoId;
    }
    return $url;
}

// Obtener datos de campos personalizados
$videoLink = '';
$galleryHtml = '';
$filesForDownload = [];

foreach ($fields as $field) {
    if ($field->name === 'link') {
        $videoLink = $field->value;
    }
    if ($field->name === 'archivos-multimedia' && !empty($field->value)) {
        $galleryHtml = $field->value;
        // Extraer archivos del subform
        if (!empty($field->rawvalue)) {
            $raw = json_decode($field->rawvalue, true);
            if (is_array($raw)) {
                foreach ($raw as $row) {
                    if (!empty($row['field6'])) {
                        $filesForDownload[] = $row;
                    }
                }
            }
        }
    }
}

// Extraer imágenes para galería
$images = [];
if (!empty($galleryHtml)) {
    preg_match_all('/<img.*?src="(.*?)".*?>/', $galleryHtml, $matches);
$images = $matches[1];
}
?>

<div class="uk-container uk-margin-large-top">
    <div class="uk-grid uk-child-width-1-2@m uk-grid-large" uk-grid>
        <!-- Lado izquierdo -->
        <div class="uk-flex uk-flex-left uk-flex-column">

            <?php if (!empty($videoLink)) :
                $embedUrl = convertirYoutubeAEmbed($videoLink); ?>
            <!-- Video -->
            <iframe src="<?= htmlspecialchars($embedUrl) ?>" width="100%" height="350" frameborder="0" allowfullscreen
                style="max-height: 500px;"></iframe>
            <?php elseif (!empty($imageData->image_intro)) : ?>
            <!-- Imagen como respaldo -->
            <img src="<?= Uri::root() . ltrim($imageData->image_intro, '/') ?>" alt="<?= $articleTitle; ?>"
                style="width: auto; max-width: 100%; height: auto; display: block; max-height: 500px;">
            <?php endif; ?>

            <?php if (!empty($images)) : ?>
            <!-- Galería -->
            <div class="uk-margin-top">
                <h3>Ver galería</h3>
                <div class="uk-grid-small uk-child-width-auto" uk-grid uk-lightbox="animation: slide">
                    <?php foreach ($images as $imgUrl):
                        $fullUrl = Uri::root() . ltrim($imgUrl, '/'); ?>
                    <div>
                        <a href="<?= $fullUrl ?>" data-caption="<?= $articleTitle ?>">
                            <img src="<?= $fullUrl ?>" alt="<?= $articleTitle ?>"
                                style="width: 100px; height: auto; border-radius: 4px; cursor: pointer;">
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!empty($filesForDownload)) : ?>
            <!-- Archivos descargables -->
            <div class="uk-margin-top">
                <h3>Descarga</h3>
                <ul>
                    <?php foreach ($filesForDownload as $row):
                        $filePath = $row['field6'];
                        $fileUrl = (strpos($filePath, 'http') === 0) ? $filePath : Uri::root() . ltrim($filePath, '/');
                        $linkText = !empty($row['field8']) ? $row['field8'] : basename($filePath);
                    ?>
                    <li>
                        <a href="<?= $fileUrl ?>" target="_blank" download style="word-wrap: break-word;">
                            <?= htmlspecialchars($linkText) ?>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

        </div>

        <!-- Lado derecho -->
        <div>
            <div class="uk-card uk-card-body uk-border-rounded">
                <h2 class="uk-card-title uk-text-bold c-af1731"><?= $articleTitle; ?></h2>
                <div class="uk-text-meta uk-margin-small-bottom">
                    <div class="uk-text-meta c-c79b66"><?= traducirFecha($this->item->publish_up); ?></div>
                </div>
                <div class="uk-article-lead uk-margin-small-top">
                    <?= HTMLHelper::_('content.prepare', $introText); ?>
                </div>
                <div class="uk-margin-medium-top">
                    <span class="uk-text-bold">Comparte:</span><br>
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($absolute_url); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="facebook"></a>
                    <a href="https://twitter.com/intent/tweet?url=<?= urlencode($absolute_url); ?>&text=<?= urlencode($articleTitle); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="twitter"></a>
                    <a href="mailto:?subject=<?= rawurlencode($articleTitle); ?>&body=<?= rawurlencode($absolute_url); ?>"
                        class="uk-icon-button" uk-icon="mail"></a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.uk-lightbox {
    z-index: 10000 !important;
}
</style>