<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;


$absolute_url = Uri::current();
$articleTitle = $this->escape($this->item->title);

$imageData = json_decode($this->item->images);
$introText = $this->item->introtext;
$articleTitle = $this->escape($this->item->title);

function traducirFecha($fechaISO) {
    $diasIngles = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
    $diasEspanol = ['lunes','martes','miércoles','jueves','viernes','sábado','domingo'];

    $mesesIngles = ['January','February','March','April','May','June','July','August','September','October','November','December'];
    $mesesEspanol = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];

    // Formato base
    $fechaEn = date('l, d \d\e F \d\e Y H:i', strtotime($fechaISO));

    // Reemplazar días y meses
    $fechaEs = str_replace($diasIngles, $diasEspanol, $fechaEn);
    $fechaEs = str_replace($mesesIngles, $mesesEspanol, $fechaEs);

    return $fechaEs;
}
?>

<div class="uk-container uk-margin-large-top">

    <div class="uk-grid uk-child-width-1-2@m uk-grid-large " uk-grid>
        <!-- Imagen a la izquierda -->
        <div class="uk-flex uk-flex-left uk-flex-column">
            <?php if (!empty($imageData->image_intro)) : ?>
            <!-- Imagen principal -->
            <img src="<?= Uri::root() . ltrim($imageData->image_intro, '/') ?>" alt="<?= $articleTitle; ?>"
                style="width: auto; max-width: 100%; height: auto; display: block; max-height: 500px;">

            <!-- Galería debajo -->
            <div class="uk-margin-top">
                <h3>Ver galeria</h3>
                <div class="uk-grid-small uk-child-width-auto" uk-grid uk-lightbox="animation: slide">
                    <div>
                        <a href="<?= Uri::root() . ltrim($imageData->image_intro, '/') ?>"
                            data-caption="<?= $articleTitle ?>">
                            <img src="<?= Uri::root() . ltrim($imageData->image_intro, '/') ?>"
                                alt="<?= $articleTitle ?>"
                                style="width: 100px; height: auto; border-radius: 4px; cursor: pointer;">
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <!-- Contenido a la derecha -->
        <div>
            <div class="uk-card  uk-card-body uk-border-rounded">

                <!-- Título -->
                <h2 class="uk-card-title uk-text-bold c-af1731"><?= $articleTitle; ?></h2>

                <!-- Fecha -->
                <div class="uk-text-meta uk-margin-small-bottom"><?php
                echo '<div class="uk-text-meta c-c79b66">'. traducirFecha($this->item->publish_up) .'</div>';?></div>

                <!-- Introtext -->
                <div class="uk-article-lead uk-margin-small-top">
                    <?= HTMLHelper::_('content.prepare', $introText); ?>
                </div>

                <!-- Comparte -->
                <div class="uk-margin-medium-top">

                    <span class="uk-text-bold">Comparte:</span><br>
                    <?php ?>
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($absolute_url); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="facebook"></a>
                    <a href="https://twitter.com/intent/tweet?url=<?= urlencode($articleUrl); ?>&text=<?= urlencode($articleTitle); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="twitter"></a>
                    <a href="mailto:?subject=<?= rawurlencode($articleTitle); ?>&body=<?= rawurlencode($articleUrl); ?>"
                        class="uk-icon-button" uk-icon="mail"></a>

                </div>

            </div>
        </div>
    </div>
</div>
<style>
.uk-lightbox {
    z-index: 10000 !important;
}
</style>