<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;

$absolute_url = Uri::current();
$articleTitle = $this->escape($this->item->title);
$imageData = json_decode($this->item->images);
$introText = $this->item->introtext;
$fields = $this->item->jcfields;

function traducirFecha($fechaISO) {
    $diasIngles = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
    $diasEspanol = ['lunes','martes','miércoles','jueves','viernes','sábado','domingo'];

    $mesesIngles = ['January','February','March','April','May','June','July','August','September','October','November','December'];
    $mesesEspanol = ['enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];

    $fechaEn = date(' d \d\e F \d\e Y H:i', strtotime($fechaISO));
    $fechaEs = str_replace($diasIngles, $diasEspanol, $fechaEn);
    $fechaEs = str_replace($mesesIngles, $mesesEspanol, $fechaEs);

    return $fechaEs;
}

// Buscar el campo 'archivos-multimedia' que contiene galería y subformulario
$galleryHtml = '';
$subformData = null;

foreach ($fields as $field) {
    if ($field->name == 'archivos-multimedianoti') {
        if (!empty($field->value)) {
            $galleryHtml = $field->value;
        }
        if (!empty($field->rawvalue)) {
            $subformData = json_decode($field->rawvalue, true);
        }
        break;
    }
}

// Extraer URLs de imágenes para galería
$images = [];
if (!empty($galleryHtml)) {
    preg_match_all('/<img.*?src="(.*?)".*?>/', $galleryHtml, $matches);
$images = $matches[1];
}

// Filtrar filas con archivos PDF en subformulario
$filesForDownload = [];
if (!empty($subformData)) {
foreach ($subformData as $row) {
if (!empty($row['field6'])) {
$filesForDownload[] = $row;
}
}
}
?>

<div class="uk-container uk-margin-large-top">

    <div class="uk-grid uk-child-width-1-2@m uk-grid-large" uk-grid>
        <!-- Imagen a la izquierda -->
        <div class="uk-flex uk-flex-left uk-flex-column">

            <?php if (!empty($imageData->image_intro)) : ?>
            <!-- Imagen principal -->
            <img src="<?= Uri::root() . ltrim($imageData->image_intro, '/') ?>" alt="<?= $articleTitle; ?>"
                style="width: auto; max-width: 100%; height: auto; display: block; max-height: 500px;">

            <?php if (!empty($images)) : ?>
            <!-- Galería debajo -->
            <div class="uk-margin-top">
                <h3>Ver galería</h3>
                <div class="uk-grid-small uk-child-width-auto" uk-grid uk-lightbox="animation: slide">
                    <?php foreach ($images as $imgUrl):
                        $fullUrl = Uri::root() . ltrim($imgUrl, '/'); ?>
                    <div>
                        <a href="<?= $fullUrl ?>" data-caption="<?= $articleTitle ?>">
                            <img src="<?= $fullUrl ?>" alt="<?= $articleTitle ?>"
                                style="width: 100px; height: auto; border-radius: 4px; cursor: pointer;">
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!empty($filesForDownload)) : ?>
            <!-- Descarga -->
            <div class="uk-margin-top">
                <h3>Descarga</h3>
                <ul>
                    <?php foreach ($filesForDownload as $row):
                        $filePath = $row['field6'];
                        $fileUrl = (strpos($filePath, 'http') === 0) ? $filePath : Uri::root() . ltrim($filePath, '/');
                        $linkText = !empty($row['field8']) ? $row['field8'] : basename($filePath);
                    ?>
                    <li>
                        <a href="<?= $fileUrl ?>" target="_blank" download
                            style="word-wrap: break-word;"><?= htmlspecialchars($linkText) ?></a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <?php endif; ?>

        </div>

        <!-- Contenido a la derecha -->
        <div>
            <div class="uk-card uk-card-body uk-border-rounded">

                <!-- Título -->
                <h2 class="uk-card-title uk-text-bold c-af1731"><?= $articleTitle; ?></h2>

                <!-- Fecha -->
                <div class="uk-text-meta uk-margin-small-bottom">
                    <?= '<div class="uk-text-meta c-c79b66">' . traducirFecha($this->item->publish_up) . '</div>'; ?>
                </div>

                <!-- Introtext -->
                <div class="uk-article-lead uk-margin-small-top">
                    <?= HTMLHelper::_('content.prepare', $introText); ?>
                </div>

                <!-- Comparte -->
                <div class="uk-margin-medium-top">

                    <span class="uk-text-bold">Comparte:</span><br>

                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($absolute_url); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="facebook"></a>

                    <a href="https://twitter.com/intent/tweet?url=<?= urlencode($absolute_url); ?>&text=<?= urlencode($articleTitle); ?>"
                        class="uk-icon-button uk-margin-small-right" uk-icon="twitter"></a>

                    <a href="mailto:?subject=<?= rawurlencode($articleTitle); ?>&body=<?= rawurlencode($absolute_url); ?>"
                        class="uk-icon-button" uk-icon="mail"></a>

                </div>

            </div>
        </div>
    </div>
</div>

<style>
.uk-lightbox {
    z-index: 10000 !important;
}
</style>