<?php
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
?>

<div class="custom-search uk-position-relative">
  <form action="<?= Route::_('index.php'); ?>" method="get" class="uk-form-stacked">
    <input
    id="mod-search"
      type="search"
      name="q"
      class="search-input"
      placeholder="Buscar..."
    />
    <input type="hidden" name="option" value="com_finder">
    <input type="hidden" name="task" value="search">
    <button id="search-btn" type="button" class="search-toggle" aria-label="Abrir/Cerrar buscador"></button>
  </form>
</div>
<style>

.custom-search {
  position: relative;
  width: 40px;
  transition: width 0.5s ease;
}

.custom-search.expanded {
  width: 300px;
  background-color: white;
  z-index: 10;
}

.search-input {
  box-sizing: border-box;
  width: 100%;
  height: 40px;
  padding: 0 40px 0 15px;
  border: 3px solid #777873;
  border-radius: 25px;
  background: transparent;
  color: #777873;
  font-size: 1rem;
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.3s ease 0.2s;
}

.custom-search.expanded .search-input {
  opacity: 1;
  pointer-events: auto;
}

.search-input::placeholder {
  color: #999;
  font-style: italic;
}

/* Botón toggle lupa/X */
.search-toggle {
  position: absolute;
  top: 0;
  right: 0;
  width: 40px;
  height: 40px;
  background: none;
  border: none;
  cursor: pointer;
}

/* Lupa */
.search-toggle::before,
.search-toggle::after {
  content: "";
  position: absolute;
  transition: 0.3s ease;
}

.search-toggle::before {
  left: 8px;
  top: 3px;
  width: 14px;
  height: 14px;
  border: 3px solid #777873;
  border-radius: 50%;
}

.search-toggle::after {
  left: 22px;
  top: 22px;
  width: 10px;
  height: 3px;
  background-color: #777873;
  transform: rotate(45deg);
}

/* Cuando está expandido, mostrar una X */
.custom-search.expanded .search-toggle::before {
  width: 20px;
  height: 3px;
  border: none;
  background-color: #777873;
  top: 18px;
  left: 10px;
  transform: rotate(45deg);
}

.custom-search.expanded .search-toggle::after {
  width: 20px;
  height: 3px;
  background-color: #777873;
  top: 18px;
  left: 10px;
  transform: rotate(-45deg);
}

</style>


