<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

$document = Factory::getDocument();
$url = JUri::base() . 'templates/puebla/html/mod_articles/temasdeinteresCss/style.css';

$document->addStyleSheet($url);

?>

<div uk-slider>
	<div class="k2temasinteres uk-position-relative uk-visible-toggle uk-light " tabindex="-1">
		<ul class="uk-slider-items uk-child-width-1-5@l uk-child-width-1-5@m uk-child-width-1-3@s uk-child-width-1-1@xs uk-grid uk-grid-small">
			<?php foreach ($list as $i): ?>
                
                <?php $img= json_decode($i->images); ?>
                <?php $attributes = ['class' => 'mod-articles-link ' . $i->active, 'itemprop' => 'url']; ?>
                <?php $link = htmlspecialchars($i->link, ENT_COMPAT, 'UTF-8', false); ?>
                <?php $title = htmlspecialchars($i->title, ENT_COMPAT, 'UTF-8', false); ?>

				<li>
					<div class="card">
						<a class="moduleItemImage" href="<?php echo $link; ?>" title="<?php echo $title ?>">
							<div class="headc">
								<?php if($img->image_intro): ?>
									<div class="imgcard" style="background:url(<?= $img->image_intro ?>);"></div>
								<?php endif; ?>
							</div>
							<div class="bodyc">
								<?php if($attributes): ?>
									<?php 
										$fecha = $i->modified;
										$dt = new DateTime($fecha);
									?>
									<h4 class="date"><?php echo "Fecha " . $dt->format('Y-m-d') ?></h4>
								<?php endif; ?>
								<h3 class="title fw-semibold"><i class="fs-bold c-a8123d" uk-icon="icon: chevron-right; ratio: 0.9;"></i><?= $i->title ?></h3>
							</div>
						</a>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
		<a alt="regresar" class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
		<a alt="avanzar" class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slider-item="next"></a>
	</div>
	<?php if($params->get('itemCustomLink')): ?>
		<div class="uk-text-right uk-light uk-margin-top">
				<a class="moduleCustomLink2 large-button bgc-c62038 bgch-c62038 c-fff uk-link-reset fs-18" href="<?php echo $link; ?>" title="<?php echo $title; ?>">
				<?php echo $link; ?>
				</a>
		</div>
	<?php endif; ?>
</div>
