<?php 

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;


$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('mod_banners.custom-style', 'templates/puebla/html/mod_articles/prevencion/style.css');

$catname = ''; $catdescription = ''; $catimg = '';

$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select($db->quoteName(['title', 'description', 'params']))
    ->from($db->quoteName('#__categories'))
    ->where($db->quoteName('id') . ' = ' . (int) $list[0]->catid);

$db->setQuery($query);
$row = $db->loadAssoc();

if ($row) {
    $catname = $row['title'];
    $catdescription = $row['description'];

	$paramsArray = json_decode($row['params'], true);
	$params = new Registry($paramsArray);

	$catimg = $params->get('image');
}



?>
<div id="k2ModuleBox<?php echo $module->id; ?>" class="k2prevencion k2ItemsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>" uk-grid>
	<div class="uk-width-1-1@l uk-width-1-1@m uk-width-1-1@s uk-width-1-1@xs">
		<div class="uk-card uk-card-small uk-card-default">
			<div class="uk-card-media-top">
				<?php if (!empty($catimg)): ?>
					<div class="imgcard" style="background:url(<?= $catimg ?>);"></div>
				<?php endif; ?>
			</div>
			<div class="uk-card-body">
				<div class="category">
					<h1 class="title"><?= $catname ?></h1>
					<h2 class="description"><?= $catdescription ?></h2>
				</div>
				<?php foreach ($list as $item): ?>
					<div class="reja">
					<a class="item-desc" href="<?php echo $item->link; ?>" title="<?php echo $item->title; ?> &quot;<?php echo $item->title; ?>&quot;">
						<h3 class="title"><?= $item->title ?></h3>
						<?php if($item->modified): ?>
						<h4 class="date">
						<?php echo $item->modified; ?>
						</h4>
					<?php endif; ?>
					</a>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div> 
