<?php
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
use Joomla\Component\Fields\Administrator\Helper\FieldsHelper;

$app = Factory::getApplication();
$input = $app->input;

$document = Factory::getDocument();
$url = JUri::base() . 'templates/puebla/html/mod_articles/temasdeinteresCss/style.css';

$document->addStyleSheet($url);

?>

<div class="itemHeader uk-width-1-1">
    <?php $img= json_decode($this->item->images); ?>
    
    <?php if($img->image_intro && !empty($img->image_intro)): ?>
        
        <div class="uk-child-width-1-1@m" uk-grid>
            <div class="uk-padding-remove">
                <div class="uk-inline uk-width-1-1">
                    
                    <img class="uk-width-1-1" src="<?php echo $img->image_intro; ?>" alt="<?= $this->image_intro_alt ?>">
                    <div class="uk-overlay uk-overlay-primary uk-position-bottom uk-padding-small">
                        <h3 class="itemTitle">
                            <?php echo $this->item->title ?>
                        </h3>
                                            
                        <div class="itemContentFooter">
                            <span class="itemDateModified">
                                <?php 
                                    $fecha = $this->item->modified;
                                    $dt = new DateTime($fecha);
                                ?>
                                Modificado: <?php echo $dt->format('Y-m-d') ?>                        
                            </span>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    <?php else: // if img not set ?>
        
        <div class="" uk-grid>
            <div class="uk-width-1-1 uk-padding-remove">

                <?php if($this->item->title): ?>
                <!-- Item title -->
                <h3 class="itemTitle">
                    <?php echo $this->item->title; ?>
                </h3>
                <?php endif; ?>
                <?php if($this->item->created): ?>
                <!-- Date created -->
                <span class="itemDateCreated uk-display-inline-block uk-margin-small-bottom">
                    <?php 
                        $fecha = $this->item->modified;
                        $dt = new DateTime($fecha);
                    ?>
                    <?php echo "Modificado: " . $dt->format('Y-m-d'); ?>
                </span>
                <?php endif; ?>

                

            </div>
        </div>
    <?php endif; ?>




    <div class="" uk-grid>
        <div class="uk-width-1-1 uk-padding-remove">

        </div>

    </div>

    <div class="itemBody uk-width-1-1">
        <?php echo ($this->item->introtext) ?>
    </div>
</div>