<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Plugin\CMSPlugin;

class PlgContentChronoforms8 extends CMSPlugin{
    public function onContentPrepare($context, &$article, &$params, $page = 0)
    {
        // Don't run this plugin when the content is being indexed
        if ($context === 'com_finder.indexer') {
            return;
        }

        // Simple performance check to determine whether bot should process further
		if(empty($article->text)){
			return;
		}
        if (strpos($article->text, '{chronoforms8}') === false) {
            return;
        }
		
		preg_match_all('#{chronoforms8}(.*?){/chronoforms8}#s', $article->text, $matches);
		
		if(!empty($matches[0])){
			require_once(JPATH_ROOT."/administrator/components/com_chronoforms8/extension.php");
			$app = ChronoApp::Instance("chronoforms8");
			
			// if ajax form, display it
			if(!empty($app->data("output") == "component")){
				$app->processExtension(action:"view", params:["chronoform" => $app->data("chronoform"), "article_id" => $article->id]);
				return;
			}
			
			foreach($matches[0] as $k => $match){
				if(!empty($matches[1][$k])){
					ob_start();
					$app->processExtension(action:"view", params:["chronoform" => $matches[1][$k], "article_id" => $article->id]);
					$form = ob_get_clean();
					
					$article->text = str_replace($matches[0][$k], $form, $article->text);
				}
			}
		}
    }
}
