<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_articles
 *
 * @copyright   (C) 2024 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

if ($params->get('articles_layout') == 1) {
    $gridCols = 'grid-cols-' . $params->get('layout_columns');
}


use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$doc = Factory::getDocument();
$doc->addStyleSheet(Uri::base() . 'modules/mod_articles/tmpl/slider_links/css/style.css');

$colors = ['color-1', 'color-2', 'color-3', 'color-4', 'color-5', 'color-6', 'color-7', 'color-8'];
$colorCount = count($colors);
$index = 0;

?>


<div uk-slider="autoplay: true; autoplay-interval: 2000">
  <div class="uk-position-relative">
    <div class="uk-slider-container">
            <ul class="uk-slider-items uk-flex uk-flex-center uk-flex-wrap-stretch uk-grid uk-grid-small uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-3@m uk-child-width-1-4@l" uk-height-match="target: > li > .card-wrapper > .uk-card">
                <?php foreach ($items as $item) : ?>
                    <?php 
                        $img = json_decode($item->images);
                        $colorClass = $colors[$index % $colorCount];
                        $index++;
                    ?>
                <li>
    <div class="card-wrapper uk-height-1-1 uk-display-block">
        <a href="<?= htmlspecialchars($item->link, ENT_QUOTES, 'UTF-8') ?>" class="uk-link-reset uk-display-block" style="height: 100%;">
            <div class="uk-card <?= $colorClass ?> uk-card-body custom-card uk-text-center uk-height-1-1">
                <?php if (!empty($img->image_intro)) : ?>
                    <img src="<?= htmlspecialchars($img->image_intro, ENT_QUOTES, 'UTF-8') ?>" alt="" style="width:100%; height:auto;">
                <?php endif; ?>
                <h4 class="uk-margin-small-top c-fff"><?= htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8') ?></h4>
            </div>
        </a>
    </div>
</li>

                <?php endforeach; ?>
            </ul>
        </div>

        <!-- Controles -->
         <div class="flechas">
        <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slider-item="previous" uk-slidenav-previous></a>
        <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slider-item="next" uk-slidenav-next></a>
         </div>
    </div>
</div>