<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');

class Chronoforms8Router extends Joomla\CMS\Component\Router\RouterBase
{
    /**
     * Build SEF URL from query parameters
     *
     * @param   array  &$query  The array of query string parameters
     * @return  array           The URL segments to append
     */
    public function build(&$query)
    {
        $segments = [];

        // If view is 'form', suppress it from the URL if linked to a menu item
        if (isset($query['view']) && $query['view'] === 'form')
        {
            // Remove the 'view' parameter so it doesn't appear in the URL
            unset($query['view']);
        }

        return $segments;
    }

    /**
     * Parse SEF URL segments back to query parameters
     *
     * @param   array  &$segments  The URL segments to parse
     * @return  array              The query parameters
     */
    public function parse(&$segments)
    {
        $vars = [];

        // If no segments, assume the default view is 'form' for menu items
        if (empty($segments))
        {
            $vars['view'] = 'form';
            return $vars;
        }

        return $vars;
    }

    /**
     * Preprocess the query to determine the menu item
     *
     * @param   array  $query  The query parameters
     * @return  array          The processed query
     */
    public function preprocess($query)
    {
        return $query;
    }
}