<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<?php
$secretKey = !empty($element["secretkey"]) ? $element["secretkey"] : Chrono::getVal($this->settings, "turnstile.secretkey");

if(!empty($secretKey)){
	$token = $_POST['cf-turnstile-response'] ?? '';

	if (!$token) {
		$this->errors[] = Chrono::l('Turnstile verification failed: no token.');
		
		$this->debug[CF8::getname($element)][] = Chrono::l('Turnstile verification failed: no token.');
		$this->set(CF8::getname($element), false);
		return;
	}

	$verifyURL = "https://challenges.cloudflare.com/turnstile/v0/siteverify";

	$data = [
		'secret' => $secretKey,
		'response' => $token,
		'remoteip' => $_SERVER['REMOTE_ADDR']
	];

	$ch = curl_init($verifyURL);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	$response = curl_exec($ch);
	$this->debug[CF8::getname($element)]['response'] = $response;

	$result = json_decode($response, true);

	if ($result["success"]) {
		// Verification passed — continue
		$this->set(CF8::getname($element), true);
		return;
	} else {
		// Verification failed
		$this->errors[] = CF8::parse($element["error"]);
		$this->set(CF8::getname($element), false);
		return;
	}
}else{
	$this->errors[] = Chrono::l('Turnstile secret key is not provided.');
	
	$this->debug[CF8::getname($element)][] = Chrono::l('No secret key is provided.');
	$this->set(CF8::getname($element), false);
}