<?php
/**
* ChronoForms 8
* Copyright (c) 2023 ChronoEngine.com, All rights reserved.
* Author: (ChronoEngine.com Team)
* license:     GNU General Public License version 2 or later; see LICENSE.txt
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
?>
<?php
$secretkey = !empty($element["secretkey"]) ? $element["secretkey"] : Chrono::getVal($this->settings, "recaptcha.secretkey");

if(!empty($secretkey)){
	if(isset($_POST['altcha']) && !empty($_POST['altcha'])){
        if(file_exists($this->path.DS.'libs/altcha/autoload.php')){
			require_once($this->path.DS.'libs/altcha/autoload.php');
		}else{
			echo 'Altcha lib not found, you can download the Altcha lib here: <a target="_blank" href="https://www.chronoengine.com/downloads/chronoforms/chronoforms-v8/">Chronoforms v8 downloads</a>';
			return;
		}

		$altcha = new AltchaOrg\Altcha\Altcha($element['secretkey']);

		$jws = $_POST['altcha']; // this is a string, not an array

		// Verify the solution
		$ok = $altcha->verifySolution(json_decode(base64_decode($jws), true), true);

		$this->debug[CF8::getname($element)]['response'] = $ok;

		if ($ok) {
			$this->set(CF8::getname($element), true);
			return;
		} else {
			$this->errors[] = CF8::parse($element["error"]);
			$this->set(CF8::getname($element), false);
			return;
		}
	}else{
		$this->errors[] = Chrono::l('Altcha value not found.');
	
		$this->debug[CF8::getname($element)][] = Chrono::l('Altcha value not found.');
		$this->set(CF8::getname($element), false);
	}
}else{
	$this->errors[] = Chrono::l('Altcha secret key is not provided.');
	
	$this->debug[CF8::getname($element)][] = Chrono::l('No secret key is provided.');
	$this->set(CF8::getname($element), false);
}